/*
 * Decompiled with CFR 0.152.
 */
package blobit.server;

import blobit.server.EmbeddedBookie;
import blobit.server.ServerConfiguration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Server {
    private static final Logger LOGGER = Logger.getLogger(Server.class.getName());
    EmbeddedBookie embeddedBookie;
    ServerConfiguration configuration;
    Path baseDirectory;

    public Server(ServerConfiguration configuration) {
        this.configuration = configuration;
        this.baseDirectory = Paths.get(configuration.getString("server.base.dir", "blobit"), new String[0]).toAbsolutePath();
    }

    public void start() throws Exception {
        boolean startBookie = this.configuration.getBoolean("server.bookkeeper.start", true);
        if (startBookie && this.embeddedBookie == null) {
            try {
                Files.createDirectories(this.baseDirectory, new FileAttribute[0]);
            }
            catch (IOException ignore) {
                LOGGER.log(Level.SEVERE, "Cannot create baseDirectory " + this.baseDirectory, ignore);
            }
            this.embeddedBookie = new EmbeddedBookie(this.baseDirectory, this.configuration);
            this.embeddedBookie.start();
        }
    }

    public void close() {
        if (this.embeddedBookie != null) {
            this.embeddedBookie.close();
        }
    }
}

