/*
 * Decompiled with CFR 0.152.
 */
package blobit.server;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class ServerConfiguration {
    private final Properties properties = new Properties();
    public static final String PROPERTY_BASEDIR = "server.base.dir";
    public static final String PROPERTY_BASEDIR_DEFAULT = "blobit";
    public static final String PROPERTY_ZOOKEEPER_ADDRESS = "server.zookeeper.address";
    public static final String PROPERTY_ZOOKEEPER_SESSIONTIMEOUT = "server.zookeeper.session.timeout";
    public static final String PROPERTY_ZOOKEEPER_PATH = "server.zookeeper.path";
    public static final String PROPERTY_DATABASE_START = "server.database.start";
    public static final boolean PROPERTY_DATABASE_START_DEFAULT = true;
    public static final String PROPERTY_BOOKKEEPER_START = "server.bookkeeper.start";
    public static final boolean PROPERTY_BOOKKEEPER_START_DEFAULT = true;
    public static final String PROPERTY_BOOKKEEPER_BOOKIE_PORT = "server.bookkeeper.port";
    public static final int PROPERTY_BOOKKEEPER_BOOKIE_PORT_DEFAULT = 3181;
    public static final String PROPERTY_BOOKKEEPER_ZK_LEDGERS_ROOT_PATH = "server.bookkeeper.zk.ledgers.root.path";
    public static final String PROPERTY_BOOKKEEPER_ZK_LEDGERS_ROOT_PATH_DEFAULT = "/ledgers";
    public static final String PROPERTY_ZOOKEEPER_ADDRESS_DEFAULT = "localhost:2181";
    public static final int PROPERTY_PORT_DEFAULT = 2183;
    public static final int PROPERTY_ZOOKEEPER_SESSIONTIMEOUT_DEFAULT = 40000;
    public static final String PROPERTY_GC_PERIOD = "server.gc.period";
    public static final int PROPERTY_GC_PERIOD_DEFAULT = 60;
    private static final Logger LOG = Logger.getLogger(ServerConfiguration.class.getName());

    public ServerConfiguration(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public ServerConfiguration(Path baseDir) {
        this();
        this.set(PROPERTY_BASEDIR, baseDir.toAbsolutePath());
    }

    public ServerConfiguration copy() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.properties);
        return new ServerConfiguration(copy);
    }

    public ServerConfiguration() {
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public int getInt(String key, int defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public long getLong(String key, long defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public String getString(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public ServerConfiguration set(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.setProperty(key, value + "");
        }
        return this;
    }

    public String toString() {
        return "ServerConfiguration{properties=" + this.properties + '}';
    }

    public List<String> keys() {
        return this.properties.keySet().stream().map(Object::toString).sorted().collect(Collectors.toList());
    }
}

