/*
 * Decompiled with CFR 0.152.
 */
package blobit.server;

import blobit.daemons.PidFileLocker;
import blobit.server.Server;
import blobit.server.ServerConfiguration;
import blobit.server.ServletHttpServerServlet;
import blobit.server.SwiftAPIAdapter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.jdbc.HerdDBDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.blobit.core.api.Configuration;
import org.blobit.core.api.ObjectManager;
import org.blobit.core.api.ObjectManagerFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;

public class ServerMain
implements AutoCloseable {
    private static ServerMain runningInstance;
    private static final Logger LOG;
    private static final CountDownLatch running;
    private final Properties configuration;
    private final PidFileLocker pidFileLocker;
    private herddb.server.Server database;
    private Server server;
    private org.eclipse.jetty.server.Server httpserver;
    private boolean started;
    private String uiurl;
    private ScheduledExecutorService gcThread;
    private ObjectManager client;
    private HerdDBDataSource datasource;

    public static void main(String ... args) {
        try {
            LOG.severe("Starting BlobIt");
            Properties configuration = new Properties();
            boolean configFileFromParameter = false;
            for (int i = 0; i < args.length; ++i) {
                int equals;
                String arg = args[i];
                if (!arg.startsWith("-")) {
                    File configFile = new File(args[i]).getAbsoluteFile();
                    LOG.severe("Reading configuration from " + configFile);
                    try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);){
                        configuration.load(reader);
                    }
                    configFileFromParameter = true;
                    continue;
                }
                if (arg.equals("--use-env")) {
                    System.getenv().forEach((key, value) -> {
                        System.out.println("Considering env as system property " + key + " -> " + value);
                        System.setProperty(key, value);
                    });
                    continue;
                }
                if (!arg.startsWith("-D") || (equals = arg.indexOf(61)) <= 0) continue;
                String key2 = arg.substring(2, equals);
                String value2 = arg.substring(equals + 1);
                System.setProperty(key2, value2);
            }
            if (!configFileFromParameter) {
                File configFile = new File("conf/server.properties").getAbsoluteFile();
                System.out.println("Reading configuration from " + configFile);
                if (configFile.isFile()) {
                    try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);){
                        configuration.load(reader);
                    }
                }
            }
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = k + "";
                if (!key.startsWith("java") && !key.startsWith("user")) {
                    configuration.put(k, v);
                }
            }));
            LogManager.getLogManager().readConfiguration();
            Runtime.getRuntime().addShutdownHook(new Thread("ctrlc-hook"){

                @Override
                public void run() {
                    System.out.println("Ctrl-C trapped. Shutting down");
                    ServerMain _brokerMain = runningInstance;
                    if (_brokerMain != null) {
                        _brokerMain.close();
                    }
                }
            });
            runningInstance = new ServerMain(configuration);
            runningInstance.start();
            runningInstance.join();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static ServerMain getRunningInstance() {
        return runningInstance;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ServerMain(Properties configuration) {
        this.configuration = configuration;
        this.pidFileLocker = new PidFileLocker(Paths.get(System.getProperty("user.dir", "."), new String[0]).toAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.gcThread != null) {
            this.gcThread.shutdown();
        }
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Exception ex) {
                Logger.getLogger(ServerMain.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                this.server = null;
            }
        }
        if (this.httpserver != null) {
            try {
                this.httpserver.stop();
            }
            catch (Exception ex) {
                Logger.getLogger(ServerMain.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                this.httpserver = null;
            }
        }
        if (this.client != null) {
            this.client.close();
        }
        if (this.database != null) {
            try {
                this.database.close();
            }
            catch (Exception ex) {
                Logger.getLogger(ServerMain.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                this.database = null;
            }
        }
        if (this.datasource != null) {
            this.datasource.close();
        }
        this.pidFileLocker.close();
        running.countDown();
    }

    public boolean isStarted() {
        return this.started;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public ObjectManager getClient() {
        return this.client;
    }

    public Server getServer() {
        return this.server;
    }

    public void join() {
        try {
            running.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.started = false;
    }

    public void start() throws Exception {
        this.pidFileLocker.lock();
        ServerConfiguration config = new ServerConfiguration(this.configuration);
        this.server = new Server(config);
        this.server.start();
        boolean startDatabase = config.getBoolean("server.database.start", true);
        if (startDatabase) {
            herddb.server.ServerConfiguration databaseConfiguration = new herddb.server.ServerConfiguration();
            databaseConfiguration.set("server.zookeeper.address", (Object)config.getString("server.zookeeper.address", "localhost:2181"));
            databaseConfiguration.set("server.mode", (Object)"cluster");
            String zkServers = config.getString("server.zookeeper.address", "localhost:2181");
            String zkLedgersRootPath = config.getString("server.bookkeeper.zk.ledgers.root.path", "/ledgers");
            String metadataServiceUri = "zk+null://" + zkServers.replace(",", ";") + "" + zkLedgersRootPath;
            databaseConfiguration.set("bookkeeper.metadataServiceUri", (Object)metadataServiceUri);
            for (Object _key : this.configuration.keySet()) {
                String key = _key.toString();
                String value = this.configuration.getProperty(key);
                if (!key.startsWith("herddb.")) continue;
                key = key.substring("herddb.".length());
                LOG.log(Level.SEVERE, "setting {0}={1} on Embedded HerdDB Server", new Object[]{key, value});
                databaseConfiguration.set(key, (Object)value);
            }
            LOG.info("HerdDB configuration: " + databaseConfiguration);
            this.database = new herddb.server.Server(databaseConfiguration);
            this.database.start();
            this.database.waitForStandaloneBoot();
        }
        int gcPeriod = config.getInt("server.gc.period", 60);
        boolean httpEnabled = config.getBoolean("http.enable", true);
        if (httpEnabled || gcPeriod > 0) {
            this.datasource = new HerdDBDataSource();
            if (this.database != null) {
                this.datasource.setUrl(this.database.getJdbcUrl());
            } else {
                String herdDbUrl = config.getString("database.url", "jdbc:herddb:zookeeper:" + config.getString("server.zookeeper.address", "localhost:2181"));
                this.datasource.setUrl(herdDbUrl);
            }
            Configuration clientConfiguration = new Configuration(this.configuration);
            this.client = ObjectManagerFactory.createObjectManager((Configuration)clientConfiguration, (DataSource)this.datasource);
        }
        if (httpEnabled) {
            String httphost = config.getString("http.host", "localhost");
            String httpadvertisedhost = config.getString("http.advertised.host", httphost);
            int httpport = config.getInt("http.port", 9846);
            int httpadvertisedport = config.getInt("http.advertised.port", 9846);
            this.httpserver = new org.eclipse.jetty.server.Server(new InetSocketAddress(httphost, httpport));
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            this.httpserver.setHandler((Handler)contexts);
            File bookieApi = new File("web/bookie");
            if (!bookieApi.isDirectory()) {
                Files.createDirectories(bookieApi.toPath(), new FileAttribute[0]);
            }
            WebAppContext webAppBookie = new WebAppContext(bookieApi.getAbsolutePath(), "/");
            webAppBookie.addServlet(new ServletHolder((Servlet)new ServletHttpServerServlet()), "/");
            contexts.addHandler((Handler)webAppBookie);
            File webUi = new File("web/api");
            if (!webUi.isDirectory()) {
                Files.createDirectories(webUi.toPath(), new FileAttribute[0]);
            }
            WebAppContext switftApi = new WebAppContext(webUi.getAbsolutePath(), "/api");
            switftApi.addServlet(new ServletHolder((Servlet)new SwiftAPIAdapter(this.client)), "/");
            contexts.addHandler((Handler)switftApi);
            this.uiurl = "http://" + httpadvertisedhost + ":" + httpadvertisedport + "/";
            System.out.println("Listening for client (http) connections on " + httphost + ":" + httpport);
            this.httpserver.start();
        }
        if (gcPeriod > 0) {
            this.gcThread = Executors.newSingleThreadScheduledExecutor();
            this.gcThread.scheduleAtFixedRate(() -> this.client.gc(), gcPeriod, gcPeriod, TimeUnit.MINUTES);
        }
        System.out.println("BlobIt server starter");
        System.out.println("Web Interface: " + this.uiurl);
        this.started = true;
    }

    public String getUiurl() {
        return this.uiurl;
    }

    static {
        LOG = Logger.getLogger(ServerMain.class.getName());
        running = new CountDownLatch(1);
    }
}

