/*
 * Decompiled with CFR 0.152.
 */
package blobit.server;

import blobit.server.ServletHttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.bookkeeper.http.AbstractHttpHandlerFactory;
import org.apache.bookkeeper.http.HttpRouter;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.HttpServiceProvider;
import org.apache.bookkeeper.http.service.ErrorHttpService;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.commons.io.IOUtils;

public class ServletHttpServerServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(ServletHttpServerServlet.class.getName());
    private final Map<String, HttpServer.ApiType> mappings = new ConcurrentHashMap<String, HttpServer.ApiType>();

    public ServletHttpServerServlet() {
        HttpRouter<HttpServer.ApiType> router = new HttpRouter<HttpServer.ApiType>((AbstractHttpHandlerFactory)new AbstractHttpHandlerFactory<HttpServer.ApiType>(ServletHttpServer.getBookie()){

            public HttpServer.ApiType newHandler(HttpServer.ApiType at) {
                return at;
            }
        }){

            public void bindHandler(String endpoint, HttpServer.ApiType mapping) {
                ServletHttpServerServlet.this.mappings.put(endpoint, mapping);
            }
        };
        router.bindAll();
    }

    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        HttpServiceResponse response;
        HttpServiceRequest request = new HttpServiceRequest().setMethod(this.convertMethod(httpRequest)).setParams(this.convertParams(httpRequest)).setBody(IOUtils.toString((InputStream)httpRequest.getInputStream(), (String)"UTF-8"));
        String uri = httpRequest.getRequestURI();
        try {
            HttpServer.ApiType apiType = this.mappings.get(uri);
            HttpServiceProvider bookie = ServletHttpServer.getBookie();
            if (bookie == null) {
                httpResponse.sendError(500);
                return;
            }
            HttpEndpointService httpEndpointService = bookie.provideHttpEndpointService(apiType);
            if (httpEndpointService == null) {
                httpResponse.sendError(404);
                return;
            }
            response = httpEndpointService.handle(request);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, "Error while service Bookie API request " + uri, e);
            response = new ErrorHttpService().handle(request);
        }
        if (response != null) {
            httpResponse.setStatus(response.getStatusCode());
            try (PrintWriter out = httpResponse.getWriter();){
                ((Writer)out).write(response.getBody());
            }
        } else {
            httpResponse.sendError(500);
        }
    }

    Map<String, String> convertParams(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration param = request.getParameterNames();
        while (param.hasMoreElements()) {
            String pName = (String)param.nextElement();
            map.put(pName, request.getParameter(pName));
        }
        return map;
    }

    HttpServer.Method convertMethod(HttpServletRequest request) {
        switch (request.getMethod()) {
            case "POST": {
                return HttpServer.Method.POST;
            }
            case "DELETE": {
                return HttpServer.Method.DELETE;
            }
            case "PUT": {
                return HttpServer.Method.PUT;
            }
        }
        return HttpServer.Method.GET;
    }
}

