/*
 * Decompiled with CFR 0.152.
 */
package blobit.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.commons.io.IOUtils;
import org.blobit.core.api.BucketConfiguration;
import org.blobit.core.api.BucketHandle;
import org.blobit.core.api.NamedObjectMetadata;
import org.blobit.core.api.ObjectManager;
import org.blobit.core.api.ObjectManagerException;
import org.blobit.core.api.ObjectNotFoundException;
import org.blobit.core.api.PutOptions;
import org.blobit.core.api.PutPromise;

@WebServlet(asyncSupported=true)
@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class SwiftAPIAdapter
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(SwiftAPIAdapter.class.getName());
    private static final String API_PATH = "/api/";
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final ObjectManager objectManager;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public SwiftAPIAdapter(ObjectManager objectManager) {
        this.objectManager = objectManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOG.log(Level.INFO, "{0} {1}", new Object[]{req.getMethod(), req.getRequestURI()});
        String requestUri = req.getRequestURI();
        if (!requestUri.startsWith(API_PATH)) {
            resp.sendError(404, "Not found " + requestUri);
            return;
        }
        switch (req.getMethod()) {
            case "HEAD": {
                String remainingPath = requestUri.substring(API_PATH.length());
                int slash = remainingPath.indexOf(47);
                if (slash <= 0) {
                    resp.sendError(404, "Not found " + requestUri);
                    return;
                }
                String container = remainingPath.substring(0, slash);
                String name = remainingPath.substring(slash + 1);
                BucketHandle bucket = this.objectManager.getBucket(container);
                try {
                    NamedObjectMetadata byName = bucket.statByName(name);
                    LOG.log(Level.FINE, "[SWIFT] head object {0} -> {1}", new Object[]{name, byName});
                    if (byName == null) {
                        resp.sendError(404, "Not found " + requestUri);
                        return;
                    }
                    resp.setContentLengthLong(byName.getSize());
                    resp.setStatus(200);
                    return;
                }
                catch (ObjectManagerException err) {
                    LOG.log(Level.SEVERE, "error", err);
                    resp.sendError(404, "Internal error " + (Object)((Object)err));
                }
                return;
            }
            case "GET": {
                String remainingPath = requestUri.substring(API_PATH.length());
                int slash = remainingPath.indexOf(47);
                if (slash <= 0) {
                    resp.sendError(404, "Not found " + requestUri);
                    return;
                }
                String container = remainingPath.substring(0, slash);
                String name = remainingPath.substring(slash + 1);
                LOG.log(Level.INFO, "[SWIFT] get {0}", new Object[]{name});
                BucketHandle bucket = this.objectManager.getBucket(container);
                AsyncContext startAsync = req.startAsync();
                bucket.downloadByName((String)name, (Consumer<Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$service$0(java.lang.String javax.servlet.http.HttpServletResponse java.lang.Long ), (Ljava/lang/Long;)V)((String)name, (HttpServletResponse)resp), (OutputStream)startAsync.getResponse().getOutputStream(), (long)0L, (long)-1L).future.handle((v, error) -> {
                    try {
                        HttpServletResponse response = (HttpServletResponse)startAsync.getResponse();
                        if (error != null) {
                            if (error instanceof ObjectNotFoundException) {
                                response.sendError(404);
                            } else {
                                LOG.log(Level.INFO, "[SWIFT] get object {0} finished, error {1}", new Object[]{name, error});
                                response.sendError(500);
                            }
                        } else {
                            LOG.log(Level.FINER, "[SWIFT] get object {0} finished", new Object[]{name});
                            response.setStatus(200);
                        }
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                    finally {
                        startAsync.complete();
                    }
                    return null;
                });
                return;
            }
            case "PUT": {
                String remainingPath = requestUri.substring(API_PATH.length());
                try {
                    int slash = remainingPath.indexOf(47);
                    if (slash <= 0) {
                        FutureUtils.result((CompletableFuture)this.objectManager.createBucket(remainingPath, remainingPath, BucketConfiguration.DEFAULT));
                        System.out.println("[SWIFT] create bucket " + remainingPath);
                        resp.setStatus(201);
                        return;
                    }
                    String container = remainingPath.substring(0, slash);
                    String name = remainingPath.substring(slash + 1);
                    BucketHandle bucket = this.objectManager.getBucket(container);
                    long expectedContentLen = req.getContentLength();
                    LOG.log(Level.INFO, "[SWIFT] put name={0} container={1} {3} bytes} ", new Object[]{name, container, expectedContentLen});
                    if (expectedContentLen == -1L) {
                        try (ServletInputStream in = req.getInputStream();){
                            IOUtils.toByteArray((InputStream)in);
                            return;
                        }
                    }
                    AsyncContext startAsync = req.startAsync();
                    PutPromise prom = bucket.put(name, expectedContentLen, (InputStream)startAsync.getRequest().getInputStream(), PutOptions.DEFAULT_OPTIONS);
                    prom.future.handle((v, error) -> {
                        try {
                            HttpServletResponse response = (HttpServletResponse)startAsync.getResponse();
                            if (error != null) {
                                LOG.log(Level.INFO, "[SWIFT] put object {0} finished, error {1}", new Object[]{name, error});
                                response.sendError(500, error + "");
                            } else {
                                LOG.log(Level.FINER, "[SWIFT] put object {0} finished", new Object[]{name});
                                response.setStatus(201);
                            }
                        }
                        catch (Exception err) {
                            LOG.log(Level.SEVERE, "Error while putting object in streaming mode", err);
                        }
                        finally {
                            startAsync.complete();
                        }
                        return null;
                    });
                    return;
                }
                catch (InterruptedException err) {
                    resp.sendError(500, err + "");
                    return;
                }
                catch (ObjectManagerException err) {
                    resp.sendError(500, err.getCause() + "");
                    LOG.log(Level.SEVERE, "Error while putting " + remainingPath, err.getCause());
                    return;
                }
                catch (Exception err) {
                    resp.sendError(500, err.getCause() + "");
                    LOG.log(Level.SEVERE, "Error while putting " + remainingPath, err.getCause());
                }
                return;
            }
        }
        resp.sendError(405, "method " + req.getMethod() + " not implemented");
    }

    private static /* synthetic */ void lambda$service$0(String name, HttpServletResponse resp, Long contentLength) {
        LOG.log(Level.INFO, "[SWIFT] get object {0} -> len {1} bytes", new Object[]{name, contentLength});
        resp.setContentLengthLong(contentLength.longValue());
        resp.setStatus(200);
        try {
            resp.flushBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

