/*
 * Decompiled with CFR 0.152.
 */
package blobit.server;

import blobit.daemons.PidFileLocker;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class ZooKeeperMainWrapper
implements AutoCloseable {
    private final Properties configuration;
    private final PidFileLocker pidFileLocker;
    private ZooKeeperServerMain server;
    private static ZooKeeperMainWrapper runningInstance;
    private static final Logger LOG;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ZooKeeperMainWrapper(Properties configuration) {
        this.configuration = configuration;
        this.pidFileLocker = new PidFileLocker(Paths.get(System.getProperty("user.dir", "."), new String[0]).toAbsolutePath());
    }

    @Override
    public void close() {
    }

    public static void main(String ... args) {
        try {
            String here = new File(System.getProperty("user.dir")).getAbsolutePath();
            Properties configuration = new Properties();
            boolean configFileFromParameter = false;
            for (int i = 0; i < args.length; ++i) {
                int equals;
                String arg = args[i];
                if (!arg.startsWith("-")) {
                    File configFile = new File(args[i]).getAbsoluteFile();
                    LOG.severe("Reading configuration from " + configFile);
                    try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);){
                        configuration.load(reader);
                    }
                    configFileFromParameter = true;
                    continue;
                }
                if (arg.equals("--use-env")) {
                    System.getenv().forEach((key, value) -> {
                        System.out.println("Considering env as system property " + key + " -> " + value);
                        System.setProperty(key, value);
                    });
                    continue;
                }
                if (!arg.startsWith("-D") || (equals = arg.indexOf(61)) <= 0) continue;
                String key2 = arg.substring(2, equals);
                String value2 = arg.substring(equals + 1);
                System.setProperty(key2, value2);
            }
            if (!configFileFromParameter) {
                File configFile = new File("conf/zoo.cfg").getAbsoluteFile();
                System.out.println("Reading configuration from " + configFile);
                if (configFile.isFile()) {
                    try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);){
                        configuration.load(reader);
                    }
                }
            }
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = k + "";
                if (!key.startsWith("java") && !key.startsWith("user")) {
                    configuration.put(k, v);
                }
            }));
            for (Object key3 : configuration.keySet()) {
                String value3 = configuration.getProperty(key3.toString());
                String newvalue = value3.replace("${user.dir}", here);
                configuration.put(key3, newvalue);
            }
            String datadir = configuration.getProperty("dataDir", null);
            if (datadir != null) {
                File file = new File(datadir);
                if (!file.isDirectory()) {
                    LOG.severe("Creating directory " + file.getAbsolutePath());
                    boolean result = file.mkdirs();
                    if (!result) {
                        LOG.severe("Failed to create directory " + file.getAbsolutePath());
                    }
                } else {
                    LOG.severe("Using directory " + file.getAbsolutePath());
                }
            }
            LogManager.getLogManager().readConfiguration();
            Runtime.getRuntime().addShutdownHook(new Thread("ctrlc-hook"){

                @Override
                public void run() {
                    System.out.println("Ctrl-C trapped. Shutting down");
                    ZooKeeperMainWrapper _brokerMain = runningInstance;
                    if (_brokerMain != null) {
                        Runtime.getRuntime().halt(0);
                    }
                }
            });
            runningInstance = new ZooKeeperMainWrapper(configuration);
            runningInstance.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Runtime.getRuntime().halt(0);
        }
    }

    public void run() throws Exception {
        this.pidFileLocker.lock();
        this.server = new ZooKeeperServerMain();
        QuorumPeerConfig qp = new QuorumPeerConfig();
        qp.parseProperties(this.configuration);
        ServerConfig sc = new ServerConfig();
        sc.readFrom(qp);
        this.server.runFromConfig(sc);
    }

    static {
        LOG = Logger.getLogger(ZooKeeperMainWrapper.class.getName());
    }
}

