/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import nu.xom.Attribute;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.euclid.Util;

public class IntArraySTAttribute
extends CMLAttribute {
    public static final String JAVA_TYPE = "int[]";
    public static final String JAVA_GET_METHOD = "getIntArray";
    public static final String JAVA_SHORT_CLASS = "IntArraySTAttribute";
    protected int[] ii = null;
    protected int length = -1;

    public IntArraySTAttribute(String name) {
        super(name);
    }

    public IntArraySTAttribute(Attribute att) {
        this(att.getLocalName());
        this.setCMLValue(att.getValue());
    }

    public IntArraySTAttribute(IntArraySTAttribute att) {
        super(att);
        if (att.ii != null) {
            this.ii = new int[att.ii.length];
            for (int i = 0; i < this.ii.length; ++i) {
                this.ii[i] = att.ii[i];
            }
        }
        this.length = att.length;
    }

    @Override
    public Node copy() {
        return new IntArraySTAttribute(this);
    }

    public IntArraySTAttribute(Attribute att, String value) {
        super(att, value.trim().replace("\\s+", " "));
    }

    public void setCMLValue(int[] ii) {
        this.checkValue(ii);
        this.ii = new int[ii.length];
        for (int i = 0; i < ii.length; ++i) {
            this.ii[i] = ii[i];
        }
        this.setValue(Util.concatenate((int[])ii, (String)" "));
    }

    public void checkValue(int[] ii) {
        if (this.cmlType != null) {
            this.cmlType.checkValue(ii);
        }
    }

    public static int[] split(String s, String delim) {
        String sss = s.trim().replace("\\s+", " ");
        if (delim == null || delim.trim().equals("") || delim.equals("\\s+")) {
            delim = "\\s+";
            sss = sss.trim();
        }
        String[] ss = sss.split(delim);
        int[] ii = new int[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            try {
                ii[i] = Integer.parseInt(ss[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("" + nfe);
            }
        }
        return ii;
    }

    @Override
    public void setCMLValue(String s) {
        int[] ii = IntArraySTAttribute.split(s.trim(), "\\s+");
        this.setCMLValue(ii);
    }

    @Override
    public Object getCMLValue() {
        return this.ii;
    }

    public int[] getIntArray() {
        return this.ii;
    }

    @Override
    public String getJavaType() {
        return JAVA_TYPE;
    }

    @Override
    public String getJavaGetMethod() {
        return JAVA_GET_METHOD;
    }

    @Override
    public String getJavaShortClassName() {
        return JAVA_SHORT_CLASS;
    }
}

