/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.element.AbstractArrayList;
import org.xmlcml.cml.element.CMLArray;
import org.xmlcml.cml.element.CMLList;
import org.xmlcml.cml.element.CMLTableContent;
import org.xmlcml.cml.element.CMLTableHeader;
import org.xmlcml.cml.element.CMLTableHeaderCell;
import org.xmlcml.cml.interfacex.HasArraySize;

public class CMLArrayList
extends AbstractArrayList {
    public CMLArrayList() {
    }

    public CMLArrayList(CMLArrayList old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new CMLArrayList(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLArrayList();
    }

    public CMLTableHeader createTableHeader() {
        CMLTableHeader tableHeader = new CMLTableHeader();
        List<HasArraySize> arraysAndLists = this.getArrays();
        for (HasArraySize node : arraysAndLists) {
            CMLTableHeaderCell tableHeaderCell = this.createTableHeaderCell(node);
            tableHeader.addTableHeaderCell(tableHeaderCell);
        }
        return tableHeader;
    }

    public CMLTableHeaderCell createTableHeaderCell(HasArraySize node) {
        CMLTableHeaderCell tableHeaderCell = null;
        if (node instanceof CMLArray) {
            tableHeaderCell = this.createTableHeaderCell((CMLArray)node);
        } else if (node instanceof CMLList) {
            tableHeaderCell = this.createTableHeaderCell((CMLList)((Object)node));
        }
        return tableHeaderCell;
    }

    public CMLTableHeaderCell createTableHeaderCell(CMLArray array) {
        CMLTableHeaderCell tableHeaderCell = new CMLTableHeaderCell();
        if (array.getTitleAttribute() != null) {
            tableHeaderCell.setTitle(array.getTitle());
        }
        if (array.getIdAttribute() != null) {
            tableHeaderCell.setId(array.getId());
        }
        if (array.getDictRefAttribute() != null) {
            tableHeaderCell.setDictRef(array.getDictRef());
        }
        if (array.getConventionAttribute() != null) {
            tableHeaderCell.setConvention(array.getConvention());
        }
        if (array.getConstantToSIAttribute() != null) {
            tableHeaderCell.setConstantToSI(array.getConstantToSI());
        }
        if (array.getMultiplierToSIAttribute() != null) {
            tableHeaderCell.setMultiplierToSI(array.getMultiplierToSI());
        }
        if (array.getDataTypeAttribute() != null) {
            tableHeaderCell.setDataType(array.getDataType());
        }
        if (array.getUnitTypeAttribute() != null) {
            tableHeaderCell.setUnitType(array.getUnitType());
        }
        if (array.getUnitsAttribute() != null) {
            tableHeaderCell.setUnits(array.getUnits());
        }
        return tableHeaderCell;
    }

    public CMLTableHeaderCell createTableHeaderCell(CMLList list) {
        List<Node> childNodes;
        CMLTableHeaderCell tableHeaderCell = new CMLTableHeaderCell();
        if (list.getTitleAttribute() != null) {
            tableHeaderCell.setTitle(list.getTitle());
        }
        if (list.getIdAttribute() != null) {
            tableHeaderCell.setId(list.getId());
        }
        if (list.getDictRefAttribute() != null) {
            tableHeaderCell.setDictRef(list.getDictRef());
        }
        if (list.getConventionAttribute() != null) {
            tableHeaderCell.setConvention(list.getConvention());
        }
        if ((childNodes = CMLUtil.getQueryNodes((Node)this, "*")).size() > 0) {
            tableHeaderCell.setDataType(((Element)childNodes.get(0)).getQualifiedName());
        }
        return tableHeaderCell;
    }

    public List<HasArraySize> getArrays() {
        ArrayList<HasArraySize> list = new ArrayList<HasArraySize>();
        List<Node> nodes = CMLUtil.getQueryNodes((Node)this, "cml:array|cml:list", CMLConstants.CML_XPATH);
        for (Node node : nodes) {
            list.add((HasArraySize)node);
        }
        return list;
    }

    public int getArraysCount() {
        return this.getArrays().size();
    }

    public CMLTableContent createTableContent() {
        List<HasArraySize> listsAndArrays;
        int nCol;
        String delimiter = this.getCommonDelimiter();
        CMLTableContent tableContent = new CMLTableContent();
        if (delimiter != null) {
            tableContent.setDelimiter(delimiter);
        }
        if ((nCol = (listsAndArrays = this.getArrays()).size()) > 0) {
            int rowCount = listsAndArrays.get(0).getArraySize();
            ArrayList<List<String>> stringLists = new ArrayList<List<String>>();
            for (HasArraySize node : listsAndArrays) {
                stringLists.add(node.getStringValues());
            }
            for (int iRow = 0; iRow < rowCount; ++iRow) {
                for (int jCol = 0; jCol < nCol; ++jCol) {
                    String s = (String)((List)stringLists.get(jCol)).get(iRow);
                    tableContent.append(s, delimiter);
                }
            }
            tableContent.finishAppendingStrings(delimiter);
        }
        return tableContent;
    }

    public String getCommonDelimiter() {
        String delimiter = null;
        CMLElements<CMLArray> arrays = this.getArrayElements();
        for (CMLArray array : arrays) {
            String delimiter0 = array.getDelimiter();
            if (delimiter == null) {
                if (delimiter0 == null) continue;
                delimiter = delimiter0;
                continue;
            }
            if (delimiter0.equals(delimiter)) continue;
            throw new RuntimeException("Cannot find common delimiter: >" + delimiter0 + "::" + delimiter + "<");
        }
        return delimiter;
    }

    public int getRowCount() {
        int rows = 0;
        if (this.getArraysCount() > 0) {
            HasArraySize array = this.getArrays().get(0);
            rows = array.getArraySize();
        }
        return rows;
    }
}

