/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.AbstractAtom;
import org.xmlcml.cml.element.CMLAtomArray;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLFormula;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Transform2;
import org.xmlcml.euclid.Transform3;
import org.xmlcml.euclid.Util;
import org.xmlcml.euclid.Vector2;
import org.xmlcml.euclid.Vector3;
import org.xmlcml.molutil.ChemicalElement;

public class CMLAtom
extends AbstractAtom {
    static final Logger LOG = Logger.getLogger(CMLAtom.class);
    public static final String NS = "cml:atom";
    List<CMLAtom> ligandAtoms = null;
    List<CMLBond> ligandBonds = null;

    public CMLAtom() {
        this.init();
    }

    void init() {
        this.ligandAtoms = new ArrayList<CMLAtom>();
        this.ligandBonds = new ArrayList<CMLBond>();
    }

    public CMLAtom(String id) {
        this.setId(id);
    }

    public CMLAtom(CMLAtom old) {
        super(old);
        this.init();
    }

    public CMLAtom(String id, ChemicalElement.AS as) {
        this(id, ChemicalElement.getChemicalElement(as));
    }

    public CMLAtom(String id, ChemicalElement chem) {
        this(id);
        this.setElementType(chem.getSymbol());
    }

    @Override
    public Node copy() {
        return new CMLAtom(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) throws RuntimeException {
        String error = null;
        CMLAtom atom = null;
        if (parent == null) {
            atom = new CMLAtom();
        } else if (parent instanceof CMLAtomArray) {
            Element grandParent = (Element)parent.getParent();
            if (grandParent == null) {
                error = "Atom needs non-null grandparent";
            } else if (grandParent instanceof CMLMolecule) {
                atom = new CMLAtom();
            } else {
                error = grandParent instanceof CMLFormula ? "Atom grandparent must be not be formula" : "Atom grandparent must be molecule";
            }
        } else {
            atom = new CMLAtom();
        }
        if (error != null) {
            throw new RuntimeException(error);
        }
        return atom;
    }

    @Override
    public void finishMakingElement(Element parent) {
        try {
            this.check();
        }
        catch (RuntimeException e) {
            LOG.warn((Object)e.getMessage());
        }
    }

    public void check() {
        CMLAtom oldAtom;
        String id = this.getId();
        if (id == null) {
            throw new RuntimeException("Atom id must not be null");
        }
        CMLMolecule molecule = this.getMolecule();
        if (molecule != null && (oldAtom = this.getMolecule().getAtomById(id)) != null && oldAtom != this) {
            oldAtom.debug("OLD ATOM");
            throw new RuntimeException("atom check: duplicate atom id: " + id);
        }
    }

    @Override
    public void setId(String id) {
        String id0 = this.getId();
        if (id0 != null) {
            if (!id0.equals(id)) {
                throw new RuntimeException("Cannot reindex id");
            }
        } else {
            CMLAtomArray atomArray;
            super.setId(id);
            ParentNode parent = this.getParent();
            if (parent != null && parent instanceof CMLAtomArray && (atomArray = (CMLAtomArray)parent) != null) {
                atomArray.indexAtom(this);
            }
        }
    }

    public List<CMLAtom> getLigandAtoms() {
        if (this.ligandAtoms == null) {
            this.ligandAtoms = new ArrayList<CMLAtom>();
        }
        return this.ligandAtoms;
    }

    public List<CMLBond> getLigandBonds() {
        if (this.ligandBonds == null) {
            this.ligandBonds = new ArrayList<CMLBond>();
        }
        return this.ligandBonds;
    }

    void addLigandBond(CMLBond bond, CMLAtom otherAtom) {
        this.getLigandAtoms();
        if (this.ligandAtoms.contains(otherAtom)) {
            throw new RuntimeException("Duplicate ligand: " + otherAtom.getId());
        }
        this.getLigandBonds();
        if (this.ligandBonds.contains(bond)) {
            throw new RuntimeException("Duplicate bond: " + bond.getAtomRefs2());
        }
        this.ligandAtoms.add(otherAtom);
        this.ligandBonds.add(bond);
    }

    void clearLigandInfo(CMLBond bond, CMLAtom otherAtom) {
        if (this.ligandAtoms != null) {
            if (!this.ligandAtoms.contains(otherAtom)) {
                throw new RuntimeException("Unknown ligand: " + otherAtom.getString());
            }
            this.ligandAtoms.remove(otherAtom);
        }
        if (this.ligandBonds != null) {
            if (!this.ligandBonds.contains(bond)) {
                throw new RuntimeException("Unknown bond: " + bond.getString());
            }
            this.ligandBonds.remove(bond);
        }
    }

    void clearLigandInfo() {
        int nlig = this.ligandAtoms.size();
        for (int i = nlig - 1; i >= 0; --i) {
            this.clearLigandInfo(this.ligandBonds.get(i), this.ligandAtoms.get(i));
        }
    }

    public CMLMolecule getMolecule() {
        ParentNode grandParent;
        ParentNode atomArray = this.getParent();
        if (atomArray != null && (grandParent = atomArray.getParent()) != null && grandParent instanceof CMLMolecule) {
            return (CMLMolecule)grandParent;
        }
        return null;
    }

    CMLAtomArray getAtomArray() {
        ParentNode parent = this.getParent();
        return parent == null || !(parent instanceof CMLAtomArray) ? null : (CMLAtomArray)parent;
    }

    @Override
    public void detach() {
        CMLAtomArray atomArray = this.getAtomArray();
        if (this.getParent() != null && atomArray != null) {
            atomArray.removeAtom(this);
        }
    }

    public List<CMLAtom> getLigandHydrogenAtoms() {
        ArrayList<CMLAtom> hydrogenAtoms = new ArrayList<CMLAtom>();
        List<CMLAtom> ligandAtoms = this.getLigandAtoms();
        for (CMLAtom ligand : ligandAtoms) {
            if (!ChemicalElement.AS.H.equals(ligand.getElementType())) continue;
            hydrogenAtoms.add(ligand);
        }
        return hydrogenAtoms;
    }

    public CMLAtom deleteAnyLigandHydrogenAtom() {
        CMLAtom ligand = null;
        List<CMLAtom> hydrogens = this.getLigandHydrogenAtoms();
        if (hydrogens.size() > 0) {
            CMLMolecule molecule = this.getMolecule();
            ligand = hydrogens.get(0);
            CMLBond bond = molecule.getBond(this, ligand);
            molecule.deleteBond(bond);
            molecule.deleteAtom(ligand);
        }
        return ligand;
    }

    public int getValenceElectrons() {
        ChemicalElement chemicalElement = this.getChemicalElement();
        if (chemicalElement != null) {
            return chemicalElement.getValenceElectrons();
        }
        return 0;
    }

    public Real2 getXY2() {
        if (this.hasCoordinates(CMLElement.CoordinateType.TWOD)) {
            return new Real2(this.getX2(), this.getY2());
        }
        return null;
    }

    public void setXY2(Real2 point) {
        this.setX2(point.getX());
        this.setY2(point.getY());
    }

    public Point3 getXYZ3() {
        if (this.hasCoordinates(CMLElement.CoordinateType.CARTESIAN)) {
            return new Point3(this.getX3(), this.getY3(), this.getZ3());
        }
        return null;
    }

    public Point3 getPoint3(CMLElement.CoordinateType type) {
        Point3 point = null;
        if (type.equals((Object)CMLElement.CoordinateType.CARTESIAN)) {
            point = this.getXYZ3();
        } else if (type.equals((Object)CMLElement.CoordinateType.FRACTIONAL)) {
            point = this.getXYZFract();
        }
        return point;
    }

    public void setXYZ3(Point3 point) {
        this.setX3(point.getArray()[0]);
        this.setY3(point.getArray()[1]);
        this.setZ3(point.getArray()[2]);
    }

    public Point3 setPoint3(Point3 point, CMLElement.CoordinateType type) {
        if (type.equals((Object)CMLElement.CoordinateType.CARTESIAN)) {
            this.setXYZ3(point);
        } else if (type.equals((Object)CMLElement.CoordinateType.FRACTIONAL)) {
            this.setXYZFract(point);
        }
        return point;
    }

    public void unsetPoint(CMLElement.CoordinateType type) {
        if (type.equals((Object)CMLElement.CoordinateType.CARTESIAN)) {
            this.unsetXYZ3();
        } else if (type.equals((Object)CMLElement.CoordinateType.FRACTIONAL)) {
            this.unsetXYZFract();
        } else if (type.equals((Object)CMLElement.CoordinateType.TWOD)) {
            this.unsetXY2();
        }
    }

    public void unsetXYZ3() {
        this.removeAttribute("x3");
        this.removeAttribute("y3");
        this.removeAttribute("z3");
    }

    public void unsetXYZFract() {
        this.removeAttribute("xFract");
        this.removeAttribute("yFract");
        this.removeAttribute("zFract");
    }

    public void unsetXY2() {
        this.removeAttribute("x2");
        this.removeAttribute("y2");
    }

    public void transformCartesians(Transform3 transform) {
        Point3 point = this.getXYZ3();
        if (point != null) {
            point = point.transform(transform);
            this.setXYZ3(point);
        }
    }

    public Point3 getXYZFract() {
        if (this.hasCoordinates(CMLElement.CoordinateType.FRACTIONAL)) {
            return new Point3(this.getXFract(), this.getYFract(), this.getZFract());
        }
        return null;
    }

    public void setXYZFract(Point3 point) {
        this.setXFract(point.getArray()[0]);
        this.setYFract(point.getArray()[1]);
        this.setZFract(point.getArray()[2]);
    }

    public void transformFractionals(Transform3 transform) {
        Point3 point = this.getXYZFract();
        point = point.transform(transform);
        this.setXYZFract(point);
    }

    public int getFormalCharge(CMLElement.FormalChargeControl control) {
        int fc;
        block2: {
            fc = 0;
            try {
                fc = this.getFormalCharge();
            }
            catch (RuntimeException e) {
                if (!CMLElement.FormalChargeControl.NO_DEFAULT.equals((Object)control)) break block2;
                throw e;
            }
        }
        return fc;
    }

    public Point3 getFractCoord() {
        if (this.getXFractAttribute() != null && this.getYFractAttribute() != null && this.getZFractAttribute() != null) {
            return new Point3(this.getXFract(), this.getYFract(), this.getZFract());
        }
        return null;
    }

    public ChemicalElement getChemicalElement() {
        return ChemicalElement.getChemicalElement(this.getElementType());
    }

    public boolean hasElement(String elementType) {
        return elementType != null && elementType.equals(this.getElementType());
    }

    public int getAtomicNumber() {
        ChemicalElement chemicalElement = this.getChemicalElement();
        return chemicalElement == null ? 0 : chemicalElement.getAtomicNumber();
    }

    public static int getCommonElementSerialNumber(String elemType) {
        String[] elems = new String[]{ChemicalElement.AS.H.value, ChemicalElement.AS.C.value, ChemicalElement.AS.N.value, ChemicalElement.AS.O.value, ChemicalElement.AS.F.value, ChemicalElement.AS.Si.value, ChemicalElement.AS.P.value, ChemicalElement.AS.S.value, ChemicalElement.AS.Cl.value, ChemicalElement.AS.Br.value, ChemicalElement.AS.I.value};
        for (int i = 0; i < elems.length; ++i) {
            if (!elems[i].equals(elemType)) continue;
            return i;
        }
        return -1;
    }

    public Vector3 get3DCrossProduct(CMLAtom atom1, CMLAtom atom2) {
        Vector3 cross = null;
        Vector3 v1 = this.getVector3(atom1);
        Vector3 v2 = this.getVector3(atom2);
        cross = v1.cross(v2);
        return cross;
    }

    public Vector3 get2DCrossProduct(CMLAtom atom1, CMLAtom atom2) {
        Vector3 cross = null;
        if (atom1 != null && atom2 != null) {
            Point3 p0 = this.get2DPoint3();
            Point3 p1 = atom1.get2DPoint3();
            Point3 p2 = atom2.get2DPoint3();
            if (p1 != null && p2 != null) {
                Vector3 v1 = p1.subtract(p0);
                Vector3 v2 = p2.subtract(p0);
                cross = v1.cross(v2);
            }
        }
        return cross;
    }

    public Point3 get2DPoint3() {
        Point3 point = null;
        if (this.hasCoordinates(CMLElement.CoordinateType.TWOD)) {
            point = new Point3(this.getX2(), this.getY2(), 0.0);
        }
        return point;
    }

    public Vector3 getVector3(CMLAtom atom1) {
        Vector3 v = null;
        if (atom1 != null) {
            Point3 p0 = this.getXYZ3();
            Point3 p1 = atom1.getXYZ3();
            if (p1 != null && p0 != null) {
                v = p1.subtract(p0);
            }
        }
        return v;
    }

    public Real2 getVector2(CMLAtom atom1) {
        Real2 v = null;
        if (atom1 != null) {
            Real2 p0 = this.getXY2();
            Real2 p1 = atom1.getXY2();
            if (p1 != null && p0 != null) {
                v = p1.subtract(p0);
            }
        }
        return v;
    }

    public void increaseXY2(double dx, double dy) {
        if (this.hasCoordinates(CMLElement.CoordinateType.TWOD)) {
            this.setX2(this.getX2() + dx);
            this.setY2(this.getY2() + dy);
        }
    }

    public void transform(Transform2 t2) {
        if (this.hasCoordinates(CMLElement.CoordinateType.TWOD)) {
            Real2 xy = new Real2(this.getX2(), this.getY2());
            xy.transformBy(t2);
            this.setX2(xy.getX());
            this.setY2(xy.getY());
        }
    }

    public void increaseXYZ3(double dx, double dy, double dz) {
        if (this.hasCoordinates(CMLElement.CoordinateType.CARTESIAN)) {
            this.setX3(this.getX3() + dx);
            this.setY3(this.getY3() + dy);
            this.setZ3(this.getZ3() + dz);
        }
    }

    public void increaseXYZFract(double dx, double dy, double dz) {
        if (this.hasCoordinates(CMLElement.CoordinateType.CARTESIAN)) {
            this.setXFract(this.getXFract() + dx);
            this.setYFract(this.getYFract() + dy);
            this.setZFract(this.getZFract() + dz);
        }
    }

    public double getDistanceTo(CMLAtom atom2) {
        Vector3 vector = this.getVector3(atom2);
        if (vector != null) {
            return this.getVector3(atom2).getLength();
        }
        throw new RuntimeException("cannot calculate distance");
    }

    public double getDistance2(CMLAtom atom2) {
        Real2 xy0 = this.getXY2();
        Real2 xy1 = atom2.getXY2();
        double distance2 = Double.NaN;
        if (xy0 != null && xy1 != null) {
            distance2 = xy0.getDistance(xy1);
        }
        return distance2;
    }

    public double getSquaredDistanceTo(CMLAtom atom2) {
        double dist2 = Double.NaN;
        Point3 p = this.getPoint3(CMLElement.CoordinateType.CARTESIAN);
        Point3 p2 = atom2.getPoint3(CMLElement.CoordinateType.CARTESIAN);
        if (p != null || p2 != null) {
            dist2 = p.getSquaredDistanceFromPoint(p2);
        }
        return dist2;
    }

    public boolean isWithinRadiusSum(CMLAtom atom2, ChemicalElement.RadiusType radiusType) {
        boolean within = false;
        ChemicalElement elem = this.getChemicalElement();
        ChemicalElement elem2 = atom2.getChemicalElement();
        if (elem != null && elem2 != null) {
            double radsum = elem.getRadius(radiusType) + elem2.getRadius(radiusType);
            double radsum2 = radsum * radsum;
            within = radsum2 > this.getSquaredDistanceTo(atom2);
        }
        return within;
    }

    public void roundCoords(double epsilon, CMLElement.CoordinateType coordinateType) {
        int i;
        epsilon = epsilon == 0.0 ? 1.0E-50 : epsilon;
        double factor = 1.0 / epsilon;
        if (CMLElement.CoordinateType.TWOD.equals((Object)coordinateType) && this.hasCoordinates(CMLElement.CoordinateType.TWOD)) {
            i = (int)(this.getX2() * factor);
            this.setX2((double)i * epsilon);
            i = (int)(this.getY2() * factor);
            this.setY2((double)i * epsilon);
        }
        if (CMLElement.CoordinateType.CARTESIAN.equals((Object)coordinateType) && this.hasCoordinates(CMLElement.CoordinateType.CARTESIAN)) {
            i = (int)(this.getX3() * factor);
            this.setX3((double)i * epsilon);
            i = (int)(this.getY3() * factor);
            this.setY3((double)i * epsilon);
            i = (int)(this.getZ3() * factor);
            this.setZ3((double)i * epsilon);
        }
        if (CMLElement.CoordinateType.FRACTIONAL.equals((Object)coordinateType) && this.hasCoordinates(CMLElement.CoordinateType.FRACTIONAL)) {
            i = (int)(this.getXFract() * factor);
            this.setXFract((double)i * epsilon);
            i = (int)(this.getYFract() * factor);
            this.setYFract((double)i * epsilon);
            i = (int)(this.getZFract() * factor);
            this.setZFract((double)i * epsilon);
        }
    }

    public boolean hasCoordinates(CMLElement.CoordinateType type) {
        boolean has = false;
        if (CMLElement.CoordinateType.TWOD.equals((Object)type)) {
            has = this.getX2Attribute() != null && this.getY2Attribute() != null;
        } else if (CMLElement.CoordinateType.CARTESIAN.equals((Object)type)) {
            has = this.getX3Attribute() != null && this.getY3Attribute() != null && this.getZ3Attribute() != null;
        } else if (CMLElement.CoordinateType.FRACTIONAL.equals((Object)type)) {
            has = this.getXFractAttribute() != null && this.getYFractAttribute() != null && this.getZFractAttribute() != null;
        }
        return has;
    }

    public int compareByAtomicNumber(CMLAtom otherAtom) {
        int thisAtnum = this.getAtomicNumber();
        int otherAtnum = otherAtom.getAtomicNumber();
        int comp = 0;
        if (thisAtnum < otherAtnum) {
            comp = -1;
        } else if (thisAtnum > otherAtnum) {
            comp = 1;
        }
        return comp;
    }

    @Override
    public int getHydrogenCount() {
        int hcAttributeValue = 0;
        if (super.getHydrogenCountAttribute() != null) {
            hcAttributeValue = super.getHydrogenCount();
        }
        int hcExplicit = this.getLigandHydrogenAtoms().size();
        return Math.max(hcAttributeValue, hcExplicit);
    }

    @Override
    public int getFormalCharge() {
        int fc = 0;
        if (super.getFormalChargeAttribute() != null) {
            fc = super.getFormalCharge();
        }
        return fc;
    }

    public static List<CMLAtom> filter(List<CMLAtom> atomList, Set<ChemicalElement> elementSet) {
        ArrayList<CMLAtom> newAtomList = new ArrayList<CMLAtom>();
        for (CMLAtom atom : atomList) {
            ChemicalElement element = atom.getChemicalElement();
            if (element == null || !elementSet.contains(element)) continue;
            newAtomList.add(atom);
        }
        return newAtomList;
    }

    public void renameId(String newId) {
        String oldId = this.getId();
        List<CMLBond> bondList = this.getLigandBonds();
        for (CMLBond ligandBond : bondList) {
            ligandBond.renameAtomRef(oldId, newId);
        }
        this.resetId(newId);
    }

    public static boolean replaceAtomRefs(String[] atomRefs, CMLAtom atom, CMLAtom rGroup, int last) {
        boolean change = false;
        if (atomRefs[0].equals(rGroup.getId())) {
            atomRefs[0] = atom.getId();
            change = true;
        } else if (atomRefs[last].equals(rGroup.getId())) {
            atomRefs[last] = atom.getId();
            change = true;
        }
        return change;
    }

    public String getString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id='" + this.getId() + "'");
        sb.append(" elementType='" + this.getElementType() + "'");
        return sb.toString();
    }

    public boolean atomIsCompatible(List<ChemicalElement.Type> typeList) {
        boolean isCompatible = false;
        ChemicalElement chemicalElement = ChemicalElement.getChemicalElement(this.getElementType());
        for (ChemicalElement.Type type : typeList) {
            if (type == null || !chemicalElement.isChemicalElementType(type)) continue;
            isCompatible = true;
        }
        return isCompatible;
    }

    public CMLAtom[] getClockwiseLigands(CMLAtom[] atom4) throws RuntimeException {
        int i;
        Vector2 vx = new Vector2(1.0, 0.0);
        Real2 thisxy = this.getXY2();
        double[] angle = new double[4];
        Vector2 v = null;
        for (int i2 = 0; i2 < 4; ++i2) {
            try {
                v = new Vector2(atom4[i2].getXY2().subtract(thisxy));
                angle[i2] = vx.getAngleMadeWith(v).getDegrees();
            }
            catch (NullPointerException npe) {
                throw new RuntimeException("Cannot compute clockwise ligands");
            }
            if (angle[i2] < 0.0) {
                int n = i2;
                angle[n] = angle[n] + 360.0;
            }
            if (!(angle[i2] > 360.0)) continue;
            int n = i2;
            angle[n] = angle[n] - 360.0;
        }
        CMLAtom[] cyclicAtom4 = new CMLAtom[4];
        for (i = 0; i < 4; ++i) {
            double minAngle = Double.MAX_VALUE;
            int low = -1;
            for (int j = 0; j < 4; ++j) {
                if (!(angle[j] >= 0.0) || !(angle[j] < minAngle)) continue;
                low = j;
                minAngle = angle[j];
            }
            if (low == -1) {
                throw new RuntimeException("Couldn't get AtomRefs4 sorted in cyclic order");
            }
            cyclicAtom4[i] = atom4[low];
            angle[low] = -100.0;
        }
        for (i = 0; i < 4; ++i) {
            Vector2 vNext;
            CMLAtom cyclicAtomNext = cyclicAtom4[i < 3 ? i + 1 : 0];
            Real2 cyclicXy = cyclicAtom4[i].getXY2();
            Real2 cyclicXyNext = cyclicAtomNext.getXY2();
            v = new Vector2(cyclicXy.subtract(thisxy));
            double ang = v.getAngleMadeWith(vNext = new Vector2(cyclicXyNext.subtract(thisxy))).getDegrees();
            if (ang < 0.0) {
                ang += 360.0;
            }
            if (ang > 360.0) {
                ang -= 360.0;
            }
            if (!(ang > 180.0)) continue;
            throw new RuntimeException("All 4 ligands on same side " + this.getId());
        }
        return cyclicAtom4;
    }

    public boolean hasCloseContact(CMLAtom atom) {
        double dist;
        double valenceDist = this.getChemicalElement().getCovalentRadius() + atom.getChemicalElement().getVDWRadius();
        return valenceDist / 2.0 > (dist = this.getDistanceTo(atom));
    }

    public static void debugAtom(String msg, CMLAtom atom) {
        if (atom == null) {
            Util.println((String)(msg + "..."));
        } else {
            Util.println((String)(msg + "..." + atom.getId()));
        }
    }

    static {
        LOG.setLevel(Level.WARN);
    }
}

