/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractLength;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLScalar;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Util;

public class CMLLength
extends AbstractLength {
    public static final String NS = "cml:length";

    public CMLLength() {
    }

    public CMLLength(CMLLength old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new CMLLength(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLLength();
    }

    public List<String> getAtomIds() {
        ArrayList<String> idList = null;
        String[] atomRefs2 = this.getAtomRefs2();
        if (atomRefs2 != null) {
            idList = new ArrayList<String>();
            for (String s : atomRefs2) {
                idList.add(s);
            }
        }
        return idList;
    }

    public List<CMLAtom> getAtoms(CMLMolecule molecule) {
        String[] atomRefs2;
        ArrayList<CMLAtom> atomList = null;
        if (molecule != null && (atomRefs2 = this.getAtomRefs2()) != null) {
            atomList = new ArrayList<CMLAtom>();
            for (String atomRef : atomRefs2) {
                CMLAtom atom = molecule.getAtomById(atomRef);
                if (atom == null) {
                    throw new RuntimeException("cannot find atom " + atomRef);
                }
                atomList.add(molecule.getAtomById(atomRef));
            }
        }
        return atomList;
    }

    public Double getCalculatedLength() {
        CMLMolecule molecule = CMLMolecule.getAncestorMolecule(this);
        return molecule == null ? null : Double.valueOf(this.getCalculatedLength(molecule));
    }

    public double getCalculatedLength(CMLMolecule molecule) {
        double calculatedLength = Double.NaN;
        if (molecule == null) {
            throw new RuntimeException("length requires molecule");
        }
        List<CMLAtom> atoms = this.getAtoms(molecule);
        ArrayList<Point3> coordList = new ArrayList<Point3>();
        if (atoms != null) {
            for (CMLAtom atom : atoms) {
                Point3 point = atom.getXYZ3();
                if (point == null) continue;
                coordList.add(point);
            }
            if (coordList.size() == 2) {
                calculatedLength = ((Point3)coordList.get(0)).getDistanceFromPoint((Point3)coordList.get(1));
            }
        } else {
            throw new RuntimeException("length requires atomRefs2");
        }
        return calculatedLength;
    }

    public static List<CMLLength> getList(CMLElements<CMLLength> lengthElements) {
        ArrayList<CMLLength> lengthList = new ArrayList<CMLLength>();
        for (CMLLength length : lengthElements) {
            lengthList.add(length);
        }
        return lengthList;
    }

    public static void addAtomIds(List<CMLLength> lengthList, CMLAtom atom0, CMLAtom atom1) {
        for (CMLLength length : lengthList) {
            length.setAtomRefs2(atom0, atom1);
        }
    }

    public static Map<String, CMLLength> getIndexedLengths(List<CMLLength> lengths) {
        HashMap<String, CMLLength> lengthTable = new HashMap<String, CMLLength>();
        for (CMLLength length : lengths) {
            String[] id = length.getAtomRefs2();
            String key = CMLBond.atomHash(id[0], id[1]);
            lengthTable.put(key, length);
        }
        return lengthTable;
    }

    public void setAtomRefs2(CMLAtom atom0, CMLAtom atom1) {
        this.setAtomRefs2(new String[]{atom0.getId(), atom1.getId()});
    }

    public String atomHash() {
        String[] a = this.getAtomRefs2();
        return a == null ? null : CMLBond.atomHash(a[0], a[1]);
    }

    public String getString() {
        String s = "";
        String[] a = this.getAtomRefs2();
        if (a != null) {
            s = s + Util.concatenate((String[])a, (String)"-");
        }
        s = s + " ";
        s = s + this.getXMLContent();
        return s;
    }

    public static void outputHTML(Writer w, List<CMLLength> lengthList, CMLMolecule molecule) throws IOException {
        if (lengthList.size() > 0) {
            w.write("<table border='1'>\n");
            w.write("<tr>");
            w.write("<th>");
            w.write("atom1 (id)");
            w.write("</th>");
            w.write("<th>");
            w.write("atom2 (id)");
            w.write("</th>");
            w.write("<th>");
            w.write("length");
            w.write("</th>");
            w.write("</tr>\n");
            for (CMLLength length : lengthList) {
                List<CMLAtom> atoms = length.getAtoms(molecule);
                w.write("<tr>");
                for (int i = 0; i < 2; ++i) {
                    w.write("<td>");
                    CMLAtom atom = atoms.get(i);
                    Nodes labelNodes = atom.query("cml:scalar[@dictRef='iucr:_atom_site_label']", CMLConstants.CML_XPATH);
                    String label = ((CMLScalar)labelNodes.get(0)).getXMLContent() + " (" + atom.getId() + ")";
                    w.write(label == null ? atom.getId() : label);
                    w.write("</td>");
                }
                String s = "" + length.getXMLContent();
                w.write("<td>" + s.substring(0, Math.min(6, s.length())) + "</td>");
                w.write("</tr>\n");
            }
            w.write("</table>\n");
        }
    }
}

