/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.element.AbstractTransform3;
import org.xmlcml.cml.element.CMLLine3;
import org.xmlcml.cml.element.CMLMatrix;
import org.xmlcml.cml.element.CMLPoint3;
import org.xmlcml.cml.element.CMLVector3;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.Axis;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.Transform3;
import org.xmlcml.euclid.Util;
import org.xmlcml.euclid.Vector3;

public class CMLTransform3
extends AbstractTransform3 {
    public static final String NS = "cml:transform3";
    public static final int SIZE = 16;
    public static final double[] UNIT44 = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};

    public CMLTransform3() {
    }

    public CMLTransform3(CMLTransform3 old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new CMLTransform3(this);
    }

    @Override
    public CMLTransform3 makeElementInContext(Element parent) {
        return new CMLTransform3();
    }

    @Override
    public void finishMakingElement(Element parent) throws RuntimeException {
        double[] array = this.getXMLContent();
        if (array == null) {
            throw new RuntimeException("line must not be empty");
        }
        if (array.length != 16) {
            throw new RuntimeException("line must have 16 double components");
        }
        this.setMatrix(array);
    }

    public CMLTransform3(Transform3 transform3) {
        this.setMatrix(transform3.getMatrixAsArray());
    }

    public CMLTransform3(double[] array) throws RuntimeException {
        this.setMatrix(array);
    }

    public CMLTransform3(Transform3.Type t) {
        Transform3 teucl3 = new Transform3(t);
        this.setMatrix(teucl3.getMatrixAsArray());
    }

    public CMLTransform3(CMLVector3 v) {
        Transform3 teucl3 = new Transform3(v.getEuclidVector3());
        this.setMatrix(teucl3.getMatrixAsArray());
    }

    public CMLTransform3(int axis, double angle) {
        Angle rot = new Angle(angle);
        Axis.Axis3 ax = null;
        if (axis == 1) {
            ax = Axis.Axis3.X;
        } else if (axis == 2) {
            ax = Axis.Axis3.Y;
        } else if (axis == 3) {
            ax = Axis.Axis3.Z;
        }
        Transform3 teucl3 = new Transform3(ax, rot);
        this.setMatrix(teucl3.getMatrixAsArray());
    }

    public CMLTransform3(double xrot, double yrot, double zrot) {
        double[] matrix = UNIT44;
        if (xrot != 0.0 || yrot != 0.0 || zrot != 0.0) {
            Transform3 teucl3 = new Transform3(new Angle(xrot), new Angle(yrot), new Angle(zrot));
            matrix = teucl3.getMatrixAsArray();
        }
        this.setMatrix(matrix);
    }

    public CMLTransform3(CMLTransform3 t, CMLPoint3 p) {
        Transform3 teucl3 = new Transform3(t.getEuclidTransform3(), p.getEuclidPoint3());
        this.setMatrix(teucl3.getMatrixAsArray());
    }

    public CMLTransform3(CMLVector3 v, double a) {
        Transform3 teucl3 = new Transform3(v.getEuclidVector3(), new Angle(a));
        this.setMatrix(teucl3.getMatrixAsArray());
    }

    public CMLTransform3(CMLLine3 l, double a) {
        Transform3 teucl3 = new Transform3(l.getEuclidLine3(), new Angle(a));
        double[] array = teucl3.getMatrixAsArray();
        this.setMatrix(array);
    }

    public CMLTransform3(CMLVector3 v1, CMLVector3 v2) {
        Transform3 teucl3 = new Transform3(v1.getEuclidVector3(), v2.getEuclidVector3());
        this.setMatrix(teucl3.getMatrixAsArray());
    }

    public CMLTransform3(CMLVector3 v1, CMLVector3 v2, CMLVector3 v3) {
        Transform3 teucl3 = new Transform3(v1.getEuclidVector3(), v2.getEuclidVector3(), v3.getEuclidVector3());
        this.setMatrix(teucl3.getMatrixAsArray());
    }

    public CMLTransform3(String opString) {
        Transform3 teucl3 = new Transform3(opString);
        double[] array = teucl3.getMatrixAsArray();
        array[15] = 1.0;
        this.setMatrix(array);
    }

    public Transform3 getEuclidTransform3() {
        return new Transform3(this.getXMLContent());
    }

    public void setMatrix(double[] matrixAsArray) throws RuntimeException {
        if (matrixAsArray.length != 16) {
            throw new RuntimeException("xyz3 must be of length 16");
        }
        this.setXMLContent(matrixAsArray);
    }

    public double[] getMatrixAsArray() {
        Transform3 teucl3 = this.getEuclidTransform3();
        return teucl3.getMatrixAsArray();
    }

    public boolean isEqualTo(CMLTransform3 m) {
        Transform3 teucl3 = this.getEuclidTransform3();
        return teucl3.isEqualTo(m.getEuclidTransform3());
    }

    public CMLTransform3 concatenate(CMLTransform3 m2) {
        Transform3 teucl3 = this.getEuclidTransform3();
        Transform3 t = teucl3.concatenate(m2.getEuclidTransform3());
        CMLTransform3 tt = new CMLTransform3(t.getMatrixAsArray());
        return tt;
    }

    public int setTransformationType(Transform3.Type option) {
        Transform3 teucl3 = this.getEuclidTransform3();
        return teucl3.setTransformationType(option);
    }

    public Transform3.Type getTransformationType() {
        Transform3 teucl3 = this.getEuclidTransform3();
        return teucl3.getTransformationType();
    }

    public double[] getAxisAndAngle() {
        Transform3 teucl3 = this.getEuclidTransform3();
        Vector3 v = new Vector3();
        Angle ang = new Angle();
        teucl3.getAxisAndAngle(v, ang);
        double[] d = new double[4];
        System.arraycopy(v.getArray(), 0, d, 0, 3);
        d[3] = ang.getRadian();
        return d;
    }

    public CMLVector3 getTranslation() {
        Transform3 teucl3 = this.getEuclidTransform3();
        Vector3 v = teucl3.getTranslation();
        return CMLVector3.createCMLVector3(v);
    }

    public CMLPoint3 getCentreOfRotation() {
        Transform3 teucl3 = this.getEuclidTransform3();
        Point3 p = teucl3.getCentreOfRotation();
        return new CMLPoint3(p);
    }

    public double[] getScales() {
        Transform3 teucl3 = this.getEuclidTransform3();
        RealArray ra = teucl3.getScales();
        return ra.getArray();
    }

    public CMLMatrix getMatrix() {
        double[] array = new double[12];
        System.arraycopy(this.getMatrixAsArray(), 0, array, 0, 12);
        return new CMLMatrix(3, 4, array);
    }

    public boolean hasNonZeroTranslationComponent() {
        boolean nonZeroTranslation = false;
        double[] matrix = this.getMatrixAsArray();
        block0: for (int i = 0; i < 3; ++i) {
            int offset = 4 * i;
            if (!(Math.abs(matrix[offset + 3]) > 0.001)) continue;
            for (int j = 0; j < 3; ++j) {
                if (!(matrix[offset + j] > 0.001)) continue;
                nonZeroTranslation = true;
                continue block0;
            }
        }
        return nonZeroTranslation;
    }

    public boolean isPureTranslation() {
        boolean hasTranslation = false;
        boolean unit = true;
        double[] matrix = this.getMatrixAsArray();
        block0: for (int i = 0; i < 3; ++i) {
            int offset = 4 * i;
            if (Math.abs(matrix[offset + 3]) > 0.001) {
                hasTranslation = true;
            }
            for (int j = 0; j < 3; ++j) {
                if (i == j) {
                    if (!(Math.abs(matrix[offset + j] - 1.0) > 0.001)) continue;
                    unit = false;
                    continue block0;
                }
                if (!(Math.abs(matrix[offset + j]) > 0.001)) continue;
                unit = false;
                continue block0;
            }
        }
        return unit && hasTranslation;
    }

    public boolean isUnit() {
        boolean unit = true;
        double[] matrix = this.getMatrixAsArray();
        int count = 0;
        block0: for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (i == j) {
                    if (!(Math.abs(matrix[count] - 1.0) < 1.0E-11)) {
                        unit = false;
                        continue block0;
                    }
                } else if (!(Math.abs(matrix[count]) < 1.0E-11)) {
                    unit = false;
                    continue block0;
                }
                ++count;
            }
        }
        return unit;
    }

    public double[] getRow(int iRow) {
        double[] row = null;
        if (iRow >= 0 && iRow <= 2) {
            row = new double[4];
            double[] matrix = this.getMatrixAsArray();
            System.arraycopy(matrix, 4 * iRow, row, 0, 4);
        }
        return row;
    }

    public boolean isEqualTo(CMLTransform3 tr2, double eps) {
        return Util.isEqual((double[])this.getXMLContent(), (double[])tr2.getXMLContent(), (double)eps);
    }

    public void normalizeCrystallographically() {
        double[] dd = this.getXMLContent();
        boolean change = false;
        for (int i = 0; i < 3; ++i) {
            double t;
            for (t = dd[4 * i + 3]; t < 0.0; t += 1.0) {
                change = true;
            }
            while (t >= 1.0) {
                t -= 1.0;
                change = true;
            }
            if (!change) continue;
            dd[4 * i + 3] = t;
        }
        if (change) {
            this.setXMLContent(dd);
        }
    }

    public static int indexOf(List<CMLTransform3> trList, CMLTransform3 tr, double eps) {
        int idx = -1;
        for (int i = 0; i < trList.size(); ++i) {
            if (!tr.isEqualTo(trList.get(i), eps)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    public Point3 transform(Point3 point) {
        Point3 newPoint = null;
        if (point != null) {
            newPoint = point.transform(this.getEuclidTransform3());
        }
        return newPoint;
    }

    public String getString() {
        return this.getEuclidTransform3().toString();
    }

    public boolean isIdentity() {
        return this.getValue().equals("1.0 0.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 0.0 1.0");
    }
}

