/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.AbstractVector3;
import org.xmlcml.cml.element.CMLPoint3;
import org.xmlcml.cml.element.CMLTransform3;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Util;
import org.xmlcml.euclid.Vector3;

public class CMLVector3
extends AbstractVector3 {
    public static final String NS = "cml:vector3";

    public CMLVector3() {
    }

    public CMLVector3(CMLVector3 old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new CMLVector3(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLVector3();
    }

    @Override
    public void finishMakingElement(Element parent) throws RuntimeException {
        double[] array = this.getXMLContent();
        if (array == null) {
            throw new RuntimeException("vector must not be empty");
        }
        if (array.length != 3) {
            throw new RuntimeException("vector must have 3 double components");
        }
    }

    public CMLVector3(double[] array) {
        this.setXYZ3(array);
    }

    public CMLVector3(Vector3 v) {
        this();
        this.setXYZ3(v.getArray());
    }

    public CMLVector3(CMLPoint3 p) {
        Vector3 v = new Vector3(p.getEuclidPoint3());
        this.setXYZ3(v.getArray());
    }

    public CMLVector3(double x, double y, double z) {
        this();
        this.setXYZ3(new double[]{x, y, z});
    }

    static CMLVector3 createCMLVector3(Vector3 v) {
        CMLVector3 vnew = new CMLVector3();
        vnew.setXMLContent(v.getArray());
        return vnew;
    }

    public Vector3 getEuclidVector3() {
        return new Vector3(this.getXMLContent());
    }

    public void setXYZ3(double[] xyz3) throws RuntimeException {
        if (xyz3.length != 3) {
            throw new RuntimeException("xyz3 must be of length 3; found: " + xyz3.length);
        }
        this.setXMLContent(xyz3);
    }

    public double[] getXYZ3() {
        return this.getXMLContent();
    }

    public boolean isEqualTo(CMLVector3 v) {
        return this.isEqualTo(v, 1.0E-14);
    }

    public boolean isEqualTo(CMLVector3 v, double eps) {
        boolean ok = true;
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(this.getXYZ3()[i] - v.getXYZ3()[i]) > eps)) continue;
            ok = false;
            break;
        }
        return ok;
    }

    public double getLength() {
        Vector3 veucl3 = this.getEuclidVector3();
        return veucl3 == null ? Double.NaN : veucl3.getLength();
    }

    public CMLVector3 getCrossProduct(CMLVector3 v3) {
        Vector3 veucl3 = this.getEuclidVector3();
        Vector3 v = veucl3.cross(v3.getEuclidVector3());
        return v == null ? null : CMLVector3.createCMLVector3(v);
    }

    public boolean longerThan(CMLVector3 v) {
        Vector3 veucl3 = this.getEuclidVector3();
        return veucl3 == null ? false : veucl3.longerThan(v.getEuclidVector3());
    }

    public CMLVector3 multiplyBy(double f) {
        Vector3 veucl3 = this.getEuclidVector3();
        Vector3 v = veucl3 == null ? null : veucl3.multiplyBy(f);
        return v == null ? null : CMLVector3.createCMLVector3(v);
    }

    public CMLVector3 plus(CMLVector3 v3) {
        Vector3 veucl3 = this.getEuclidVector3();
        Vector3 v = veucl3 == null ? null : veucl3.plus(v3.getEuclidVector3());
        return v == null ? null : CMLVector3.createCMLVector3(v);
    }

    public CMLVector3 subtract(CMLVector3 v3) {
        Vector3 veucl3 = this.getEuclidVector3();
        Vector3 v = veucl3 == null ? null : veucl3.subtract(v3.getEuclidVector3());
        return v == null ? null : CMLVector3.createCMLVector3(v);
    }

    public double elementAt(int n) throws RuntimeException {
        Util.check((int)n, (int)0, (int)2);
        Vector3 veucl3 = this.getEuclidVector3();
        return veucl3 == null ? Double.NaN : veucl3.elementAt(n);
    }

    public void setElementAt(int n, double f) throws EuclidRuntimeException {
        Util.check((int)n, (int)0, (int)2);
        Vector3 veucl3 = this.getEuclidVector3();
        veucl3.setElementAt(n, f);
        this.setXMLContent(veucl3.getArray());
    }

    public boolean isZero() {
        Vector3 veucl3 = this.getEuclidVector3();
        return veucl3 == null ? false : veucl3.isZero();
    }

    public CMLVector3 transform(CMLTransform3 t) {
        Vector3 veucl3 = this.getEuclidVector3();
        Vector3 v = veucl3 == null ? null : veucl3.transform(t.getEuclidTransform3());
        return v == null ? null : CMLVector3.createCMLVector3(v);
    }

    public CMLVector3 normalize() throws RuntimeException {
        if (this.isZero()) {
            throw new RuntimeException("Cannot normalize zero vector");
        }
        Vector3 veucl3 = this.getEuclidVector3();
        if (veucl3 != null) {
            veucl3.normalize();
            this.setXMLContent(veucl3.getArray());
        }
        return this;
    }

    public double dot(CMLVector3 v3) {
        Vector3 veucl3 = this.getEuclidVector3();
        return veucl3 == null ? Double.NaN : veucl3.dot(v3.getEuclidVector3());
    }

    public Angle getAngleMadeWith(CMLVector3 v2) {
        Vector3 veucl3 = this.getEuclidVector3();
        return veucl3 == null ? null : veucl3.getAngleMadeWith(v2.getEuclidVector3());
    }

    public double getScalarTripleProduct(CMLVector3 v2, CMLVector3 v3) {
        Vector3 veucl3 = this.getEuclidVector3();
        return veucl3 == null ? null : Double.valueOf(veucl3.getScalarTripleProduct(v2.getEuclidVector3(), v3.getEuclidVector3()));
    }

    public CMLVector3 projectOnto(CMLVector3 v) {
        Vector3 veucl3 = this.getEuclidVector3();
        Vector3 vv = null;
        try {
            vv = veucl3 == null ? null : veucl3.projectOnto(v.getEuclidVector3());
        }
        catch (EuclidRuntimeException euclidRuntimeException) {
            // empty catch block
        }
        return vv == null ? null : CMLVector3.createCMLVector3(vv);
    }

    public boolean isColinearVector(CMLVector3 v) {
        Vector3 veucl3 = this.getEuclidVector3();
        return veucl3 == null ? false : veucl3.isColinearVector(v.getEuclidVector3());
    }

    public CMLVector3 getNonColinearVector() {
        Vector3 v = this.getEuclidVector3().getNonColinearVector();
        return v == null ? null : CMLVector3.createCMLVector3(v);
    }

    public CMLVector3 getPerpendicularVector() {
        Vector3 v = this.getEuclidVector3().getPerpendicularVector();
        return v == null ? null : CMLVector3.createCMLVector3(v);
    }

    public String getString() {
        return this.getEuclidVector3().toString();
    }
}

