/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.AbstractZMatrix;
import org.xmlcml.cml.element.CMLAngle;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLLength;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLTorsion;
import org.xmlcml.cml.element.FullTorsion;
import org.xmlcml.cml.element.Sprout;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Util;
import org.xmlcml.euclid.Vector3;

public class CMLZMatrix
extends AbstractZMatrix {
    public static final String NS = "cml:zMatrix";
    List<CMLLength> lengthList = null;
    List<CMLAngle> angleList = null;
    List<CMLTorsion> torsionList = null;
    Map<String, CMLLength> lengthByAtomHashMap;
    Map<String, CMLAngle> angleByAtomHashMap;
    Map<String, List<CMLTorsion>> torsionByAtomMap;
    Set<String> currentAtomSet;
    Set<String> deadAtomSet;
    Set<String> finalAtomSet;
    Set<CMLTorsion> currentTorsionSet;
    List<CMLTorsion> deadTorsionList;
    List<CMLLength> deadLengthList;
    List<CMLAngle> deadAngleList;

    public CMLZMatrix() {
    }

    public CMLZMatrix(CMLZMatrix old) {
        super(old);
    }

    public CMLZMatrix(CMLElement element) throws RuntimeException {
        this.makeZMatrix(element);
    }

    @Override
    public Node copy() {
        return new CMLZMatrix(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLZMatrix();
    }

    public void addCartesiansTo(CMLMolecule molecule) {
        Elements lengthElements = this.getChildCMLElements("length");
        Elements angleElements = this.getChildCMLElements("angle");
        Elements torsionElements = this.getChildCMLElements("torsion");
        if (lengthElements.size() != 0) {
            if (lengthElements.size() == 1) {
                CMLLength length = (CMLLength)lengthElements.get(0);
                String id = length.getAtomRefs2()[1];
                CMLAtom atom0 = molecule.getAtomById(id);
                if (atom0 == null) {
                    throw new RuntimeException("Cannot find atom: " + id);
                }
                id = length.getAtomRefs2()[0];
                CMLAtom atom1 = molecule.getAtomById(id);
                if (atom1 == null) {
                    throw new RuntimeException("Cannot find atom: " + id);
                }
                atom0.setXYZ3(new Point3(0.0, 0.0, 0.0));
                atom1.setXYZ3(new Point3(length.getXMLContent(), 0.0, 0.0));
            } else if (lengthElements.size() == 2) {
                this.setCoordinates((CMLAngle)angleElements.get(0), (CMLLength)lengthElements.get(0), (CMLLength)lengthElements.get(1), molecule);
            } else {
                if (angleElements.size() == 0) {
                    this.debug("BAD ZMATRIX");
                    throw new RuntimeException("Bad zMatrix");
                }
                this.setCoordinates((CMLAngle)angleElements.get(0), (CMLLength)lengthElements.get(0), (CMLLength)lengthElements.get(1), molecule);
                for (int itors = 0; itors < torsionElements.size(); ++itors) {
                    this.setXYZ3((CMLLength)lengthElements.get(itors + 2), (CMLAngle)angleElements.get(itors + 1), (CMLTorsion)torsionElements.get(itors), molecule);
                }
            }
        }
    }

    private void setCoordinates(CMLAngle angle, CMLLength length0, CMLLength length1, CMLMolecule molecule) {
        int i0 = -1;
        int i2 = -1;
        if (CMLBond.atomHash(length0.getAtomRefs2()).equals(CMLBond.atomHash(angle.getAtomRefs3()[0], angle.getAtomRefs3()[1]))) {
            i0 = 0;
            i2 = 2;
        } else if (CMLBond.atomHash(length0.getAtomRefs2()).equals(CMLBond.atomHash(angle.getAtomRefs3()[2], angle.getAtomRefs3()[1]))) {
            i0 = 2;
            i2 = 0;
        } else {
            throw new RuntimeException("Cannot match lengths to angle");
        }
        String id = angle.getAtomRefs3()[i0];
        CMLAtom atom0 = molecule.getAtomById(id);
        if (atom0 == null) {
            throw new RuntimeException("Cannot find atom: " + id);
        }
        id = angle.getAtomRefs3()[1];
        CMLAtom atom1 = molecule.getAtomById(id);
        if (atom1 == null) {
            throw new RuntimeException("Cannot find atom: " + id);
        }
        id = angle.getAtomRefs3()[i2];
        CMLAtom atom2 = molecule.getAtomById(id);
        atom0.setXYZ3(new Point3(0.0, 0.0, 0.0));
        double l0 = length0.getXMLContent();
        atom1.setXYZ3(new Point3(l0, 0.0, 0.0));
        double l1 = length1.getXMLContent();
        double anglex = angle.getXMLContent() * Math.PI / 180.0;
        double sina = Math.sin(anglex);
        double cosa = Math.cos(anglex);
        atom2.setXYZ3(new Point3(l0 - l1 * cosa, l1 * sina, 0.0));
    }

    public void setXYZ3(CMLLength length, CMLAngle angle, CMLTorsion torsion, CMLMolecule molecule) {
        String[] atomRefs4 = torsion.getAtomRefs4();
        CMLAtom atom0 = molecule.getAtomById(atomRefs4[0]);
        CMLAtom atom1 = molecule.getAtomById(atomRefs4[1]);
        CMLAtom atom2 = molecule.getAtomById(atomRefs4[2]);
        CMLAtom atom3 = molecule.getAtomById(atomRefs4[3]);
        Point3 p0 = atom0.getXYZ3();
        Point3 p1 = atom1.getXYZ3();
        Point3 p2 = atom2.getXYZ3();
        Point3 p3 = atom3.getXYZ3();
        if (p0 == null) {
            throw new RuntimeException("should not be null p0 " + atom0.getId());
        }
        if (p1 == null) {
            throw new RuntimeException("should not be null p1 " + atom1.getId());
        }
        if (p2 == null) {
            throw new RuntimeException("should not be null p2 " + atom2.getId());
        }
        if (p3 != null) {
            throw new RuntimeException("should be null p3 " + atom3.getId());
        }
        Vector3 v01 = p0.subtract(p1);
        Vector3 v12 = p2.subtract(p1);
        Vector3 cross1 = v01.cross(v12);
        cross1 = cross1.normalize();
        Vector3 cross2 = v12.cross(cross1);
        cross2 = cross2.normalize();
        double tangle = torsion.getXMLContent() * Math.PI / 180.0;
        Vector3 cross1a = cross1.multiplyBy(Math.sin(-tangle));
        Vector3 cross2a = cross2.multiplyBy(Math.cos(tangle));
        Vector3 cross3 = cross1a.plus(cross2a);
        cross3 = cross3.normalize();
        Vector3 v12a = v12.normalize();
        double len = length.getXMLContent();
        double ang = angle.getXMLContent() * Math.PI / 180.0;
        p3 = new Point3(p2);
        p3 = p3.plus(cross3.multiplyBy(len * Math.sin(ang)));
        p3 = p3.subtract(v12a.multiplyBy(len * Math.cos(ang)));
        atom3.setXYZ3(p3);
    }

    void makeZMatrix(CMLElement element) {
        this.lengthList = this.makeLengthList(element);
        this.angleList = this.makeAngleList(element, this.lengthList.size());
        this.torsionList = this.makeTorsionList(element, this.lengthList.size());
        this.currentAtomSet = new HashSet<String>();
        this.deadAtomSet = new HashSet<String>();
        this.torsionByAtomMap = new HashMap<String, List<CMLTorsion>>();
        this.currentTorsionSet = new HashSet<CMLTorsion>();
        this.finalAtomSet = new HashSet<String>();
        this.deadTorsionList = new ArrayList<CMLTorsion>();
        this.deadLengthList = new ArrayList<CMLLength>();
        this.deadAngleList = new ArrayList<CMLAngle>();
        this.lengthByAtomHashMap = new HashMap<String, CMLLength>();
        for (CMLLength length : this.lengthList) {
            this.lengthByAtomHashMap.put(length.atomHash(), length);
        }
        this.angleByAtomHashMap = new HashMap<String, CMLAngle>();
        for (CMLAngle angle : this.angleList) {
            this.angleByAtomHashMap.put(angle.atomHash(), angle);
        }
        this.makeTorsionByAtomMap();
        if (this.lengthList.size() == 1) {
            this.appendChild((Node)new CMLLength(this.lengthList.get(0)));
        } else if (this.lengthList.size() == 2) {
            this.appendChild((Node)new CMLLength(this.lengthList.get(0)));
            this.appendChild((Node)new CMLLength(this.lengthList.get(1)));
            this.appendChild((Node)new CMLAngle(this.angleList.get(0)));
        } else {
            this.addFirstFullTorsion();
            while (true) {
                Sprout sprout;
                if ((sprout = this.getNextSprout()) == null) {
                    if (this.torsionList.size() == 0) break;
                    throw new RuntimeException("UNUSED TORSIONs");
                }
                this.addSprout(sprout);
            }
        }
    }

    private void addFirstFullTorsion() {
        CMLTorsion torsion = null;
        for (CMLTorsion t : this.torsionList) {
            FullTorsion ft = this.getFullTorsion(t);
            if (ft == null) continue;
            this.addFullTorsion(ft);
            torsion = t;
            break;
        }
        if (torsion == null) {
            throw new RuntimeException("Cannot find a first full torsion");
        }
    }

    private void addFullTorsion(FullTorsion ft) {
        CMLTorsion tNew = this.getNewTorsion(ft.torsion);
        String[] at = tNew.getAtomRefs4();
        this.addAtom(at[0]);
        this.addAtom(at[1]);
        this.addAtom(at[2]);
        this.addToMolecule(ft.length1);
        this.addToMolecule(ft.length2);
        this.addToMolecule(ft.angle12);
        this.addToMolecule(ft.length3);
        this.addToMolecule(ft.angle23);
        this.addToMolecule(ft.torsion);
    }

    void addToMolecule(CMLLength l) {
        CMLLength l1 = this.getNewLength(l);
        this.lengthList.remove(l);
        this.deadLengthList.add(l);
        this.appendChild((Node)l1);
    }

    void addToMolecule(CMLAngle a) {
        CMLAngle a1 = this.getNewAngle(a);
        this.angleList.remove(a);
        this.deadAngleList.add(a);
        this.appendChild((Node)a1);
    }

    void addToMolecule(CMLTorsion tor) {
        CMLTorsion t1 = this.getNewTorsion(tor);
        String atomRef = t1.getAtomRefs4()[3];
        if (this.finalAtomSet.contains(atomRef)) {
            throw new RuntimeException("Atom already in atomSet: " + atomRef);
        }
        this.addAtom(atomRef);
        this.appendChild((Node)t1);
        this.torsionList.remove(tor);
        this.deadTorsionList.add(tor);
        List<String> removedAtomIds = this.removeTorsion(this.torsionByAtomMap, tor);
        for (String atomId : removedAtomIds) {
            this.deadAtomSet.add(atomId);
            this.currentAtomSet.remove(atomId);
        }
        this.currentTorsionSet.remove(tor);
    }

    void debugPrint() {
        Util.println((String)"------DEAD ATOMS------");
        for (String string : this.deadAtomSet) {
            Util.println((String)string);
        }
        Util.println((String)"------DEAD LENGTH------");
        for (CMLLength cMLLength : this.deadLengthList) {
            Util.println((String)cMLLength.getString());
        }
        Util.println((String)"------DEAD ANGLE------");
        for (CMLAngle cMLAngle : this.deadAngleList) {
            Util.println((String)cMLAngle.getString());
        }
        Util.println((String)"------DEAD TORSION------");
        for (CMLTorsion cMLTorsion : this.deadTorsionList) {
            Util.println((String)cMLTorsion.getString());
        }
        Util.println((String)"-------CURRENT ATOMS---------");
        for (String string : this.currentAtomSet) {
            Util.println((String)string);
        }
        Util.println((String)"-------FINAL ATOM SET---------");
        for (String string : this.finalAtomSet) {
            Util.println((String)string);
        }
        Util.println((String)"-------LENGTH LIST---------");
        for (CMLLength cMLLength : this.lengthList) {
            Util.println((String)cMLLength.getString());
        }
        Util.println((String)"--------ANGLE LIST--------");
        for (CMLAngle cMLAngle : this.angleList) {
            Util.println((String)("" + cMLAngle.getString()));
        }
        Util.println((String)"-------TORSION LIST---------");
        for (CMLTorsion cMLTorsion : this.torsionList) {
            Util.println((String)cMLTorsion.getString());
        }
        Util.println((String)"-------CURRENT TORSION SET---------");
    }

    void addAtom(String atomRef) {
        this.currentAtomSet.add(atomRef);
        this.finalAtomSet.add(atomRef);
        List<CMLTorsion> tList = this.torsionByAtomMap.get(atomRef);
        if (tList != null) {
            for (CMLTorsion t : tList) {
                this.currentTorsionSet.add(t);
            }
        }
    }

    void addSprout(Sprout sprout) {
        this.addToMolecule(sprout.length);
        this.addToMolecule(sprout.angle);
        this.addToMolecule(sprout.torsion);
        this.finalAtomSet.add(sprout.atom);
    }

    CMLLength getNewLength(CMLLength l) {
        String[] a = l.getAtomRefs2();
        CMLLength length = new CMLLength(l);
        if (this.finalAtomSet.contains(a[1])) {
            String[] aa = new String[]{a[1], a[0]};
            length.setAtomRefs2(aa);
        }
        return length;
    }

    CMLAngle getNewAngle(CMLAngle ang) {
        String[] a = ang.getAtomRefs3();
        CMLAngle angle = new CMLAngle(ang);
        if (this.finalAtomSet.contains(a[2])) {
            String[] aa = new String[]{a[2], a[1], a[0]};
            angle.setAtomRefs3(aa);
        }
        return angle;
    }

    CMLTorsion getNewTorsion(CMLTorsion tor) {
        String[] a = tor.getAtomRefs4();
        CMLTorsion torsion = new CMLTorsion(tor);
        if (this.finalAtomSet.contains(a[3])) {
            String[] aa = new String[]{a[3], a[2], a[1], a[0]};
            torsion.setAtomRefs4(aa);
        }
        return torsion;
    }

    Sprout getNextSprout() {
        Sprout sprout = null;
        for (CMLTorsion t : this.currentTorsionSet) {
            List<String> freeAtomList = this.getFreeAtomList(t);
            if (freeAtomList.size() == 1) {
                String atom = freeAtomList.get(0);
                if (this.deadAtomSet.contains(atom) || (sprout = this.getSprout(t, atom)) == null) continue;
                break;
            }
            if (freeAtomList.size() <= 1) continue;
        }
        return sprout;
    }

    Sprout getSprout(CMLTorsion t, String atom) {
        String[] atomRefs4 = t.getAtomRefs4();
        CMLLength length = null;
        CMLAngle angle = null;
        if (atom.equals(atomRefs4[0])) {
            length = this.lengthByAtomHashMap.get(CMLBond.atomHash(atomRefs4[0], atomRefs4[1]));
            angle = this.angleByAtomHashMap.get(CMLAngle.atomHash(atomRefs4[0], atomRefs4[1], atomRefs4[2]));
        } else if (atom.equals(atomRefs4[3])) {
            length = this.lengthByAtomHashMap.get(CMLBond.atomHash(atomRefs4[2], atomRefs4[3]));
            if (length == null) {
                // empty if block
            }
            angle = this.angleByAtomHashMap.get(CMLAngle.atomHash(atomRefs4[1], atomRefs4[2], atomRefs4[3]));
        } else {
            throw new RuntimeException("Sprout cannot be in middle of torsion");
        }
        return length != null && angle != null ? new Sprout(atom, length, angle, t) : null;
    }

    private List<String> getFreeAtomList(CMLTorsion t) {
        String[] atomRefs4;
        ArrayList<String> list = new ArrayList<String>();
        for (String atomRef : atomRefs4 = t.getAtomRefs4()) {
            if (this.finalAtomSet.contains(atomRef)) continue;
            list.add(atomRef);
        }
        return list;
    }

    private FullTorsion getFullTorsion(CMLTorsion torsion) {
        String[] a = torsion.getAtomRefs4();
        boolean ok = true;
        CMLLength length1 = null;
        CMLLength length2 = null;
        CMLAngle angle12 = null;
        CMLLength length3 = null;
        CMLAngle angle23 = null;
        length1 = this.lengthByAtomHashMap.get(CMLBond.atomHash(a[0], a[1]));
        if (length1 == null) {
            ok = false;
        }
        if (ok && (length2 = this.lengthByAtomHashMap.get(CMLBond.atomHash(a[1], a[2]))) == null) {
            ok = false;
        }
        if (ok && (angle12 = this.angleByAtomHashMap.get(CMLAngle.atomHash(a[0], a[1], a[2]))) == null) {
            ok = false;
        }
        if (ok && (length3 = this.lengthByAtomHashMap.get(CMLBond.atomHash(a[2], a[3]))) == null) {
            ok = false;
        }
        if (ok && (angle23 = this.angleByAtomHashMap.get(CMLAngle.atomHash(a[1], a[2], a[3]))) == null) {
            ok = false;
        }
        return !ok ? null : new FullTorsion(length1, length2, angle12, length3, angle23, torsion);
    }

    private void makeTorsionByAtomMap() {
        for (CMLTorsion torsion : this.torsionList) {
            String[] atomRefs4 = torsion.getAtomRefs4();
            this.addTorsion(this.torsionByAtomMap, atomRefs4[0], torsion);
            this.addTorsion(this.torsionByAtomMap, atomRefs4[1], torsion);
            this.addTorsion(this.torsionByAtomMap, atomRefs4[2], torsion);
            this.addTorsion(this.torsionByAtomMap, atomRefs4[3], torsion);
        }
        for (String atomId : this.torsionByAtomMap.keySet()) {
            List<CMLTorsion> torsionList = this.torsionByAtomMap.get(atomId);
            String s = atomId + ": ";
            for (CMLTorsion torsion : torsionList) {
                s = s + " (" + torsion.getString() + ")";
            }
        }
    }

    private void addTorsion(Map<String, List<CMLTorsion>> torsionByAtomMap, String atomId, CMLTorsion torsion) {
        List<CMLTorsion> torsionList = torsionByAtomMap.get(atomId);
        if (torsionList == null) {
            torsionList = new ArrayList<CMLTorsion>();
            torsionByAtomMap.put(atomId, torsionList);
        }
        torsionList.add(torsion);
    }

    private List<String> removeTorsion(Map<String, List<CMLTorsion>> torsionByAtomMap, CMLTorsion torsion) {
        ArrayList<String> deadAtomList = new ArrayList<String>();
        for (String atomRef : torsion.getAtomRefs4()) {
            List<CMLTorsion> torsionList = this.removeTorsion(torsionByAtomMap, atomRef, torsion);
            if (torsionList != null && torsionList.size() != 0) continue;
            deadAtomList.add(atomRef);
        }
        return deadAtomList;
    }

    private List<CMLTorsion> removeTorsion(Map<String, List<CMLTorsion>> torsionByAtomMap, String atomId, CMLTorsion torsion) {
        List<CMLTorsion> torsionList = torsionByAtomMap.get(atomId);
        if (torsionList != null) {
            torsionList.remove(torsion);
        }
        return torsionList;
    }

    private List<CMLLength> makeLengthList(CMLElement element) {
        Elements lengthElements = element.getChildCMLElements("length");
        ArrayList<CMLLength> lengthList = new ArrayList<CMLLength>();
        for (int i = 0; i < lengthElements.size(); ++i) {
            lengthList.add((CMLLength)lengthElements.get(i));
        }
        if (lengthList.size() == 0) {
            throw new RuntimeException("no length elements in ZMatrix");
        }
        return lengthList;
    }

    private List<CMLAngle> makeAngleList(CMLElement element, int nlength) {
        Elements angleElements = element.getChildCMLElements("angle");
        ArrayList<CMLAngle> angleList = new ArrayList<CMLAngle>();
        for (int i = 0; i < angleElements.size(); ++i) {
            angleList.add((CMLAngle)angleElements.get(i));
        }
        int nangle = angleList.size();
        if (nangle + 1 != nlength) {
            throw new RuntimeException("wrong number of angle elements (" + nangle + ") for length Elements (" + nlength + ") in ZMatrix");
        }
        return angleList;
    }

    private List<CMLTorsion> makeTorsionList(CMLElement element, int nlength) {
        Elements torsionElements = element.getChildCMLElements("torsion");
        ArrayList<CMLTorsion> torsionList = new ArrayList<CMLTorsion>();
        for (int i = 0; i < torsionElements.size(); ++i) {
            torsionList.add((CMLTorsion)torsionElements.get(i));
        }
        int ntorsion = torsionList.size();
        if (ntorsion + 2 != nlength) {
            throw new RuntimeException("wrong number of torsion elements (" + ntorsion + ") for length Elements (" + nlength + ") in ZMatrix");
        }
        return torsionList;
    }
}

