/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.molutil;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLUtil;

public class ChemicalElement {
    static final Logger logger = Logger.getLogger(ChemicalElement.class);
    public static final int MAXELEM = 150;
    static final String ELEMENT_FILE = "org/xmlcml/molutil/elementdata.xml";
    static final double DEFAULT_ATOMIC_RADIUS = 1.6;
    static final double DEFAULT_COVALENT_RADIUS = 1.4;
    static final double DEFAULT_VDW_RADIUS = 2.0;
    static final double DEFAULT_BONDING_RADIUS_TOLERANCE = 0.2;
    static double bondingRadiusTolerance = 0.2;
    static Hashtable<String, ChemicalElement> pTable = new Hashtable();
    public static ChemicalElement[] periodicTable = new ChemicalElement[150];
    protected final int atomicNumber;
    protected final double atomicWeight;
    protected final String atomicSymbol;
    protected int group;
    protected int period;
    protected String electronicGroundState;
    protected int[] isotopeMasses;
    protected double[] isotopeAbundances;
    protected double[] isotopePreciseMasses;
    protected double covalentRadius;
    protected double atomicRadius;
    protected double vanderwaalsRadius;
    protected double electronegativity;
    protected Color color;

    public ChemicalElement(String symbol, int atomicNumber, double atomicWeight) {
        this.atomicSymbol = symbol;
        this.atomicNumber = atomicNumber;
        this.atomicWeight = atomicWeight;
        ChemicalElement.periodicTable[atomicNumber] = this;
    }

    public String getSymbol() {
        return this.atomicSymbol;
    }

    public int getAtomicNumber() {
        return this.atomicNumber;
    }

    public double getAtomicWeight() {
        return this.atomicWeight;
    }

    public int getGroup() {
        return this.group;
    }

    public int getPeriod() {
        return this.period;
    }

    public String getElectronicGroundState() {
        return this.electronicGroundState;
    }

    public void addIsotope(int[] masses, double[] abundances) {
        this.setIsotopes(masses, abundances);
    }

    public void setIsotopes(int[] masses, double[] abundances) {
        this.isotopeMasses = masses;
        this.isotopeAbundances = abundances;
    }

    public void setIsotopePreciseMasses(double[] preciseMasses) {
        this.isotopePreciseMasses = preciseMasses;
    }

    public int[] getIsotopeMasses() {
        return this.isotopeMasses;
    }

    public double[] getIsotopeAbundances() {
        return this.isotopeAbundances;
    }

    public double[] getIsotopePreciseMasses() {
        return this.isotopePreciseMasses;
    }

    public int getMainIsotope() {
        double max = -1.0;
        int mainMass = -1;
        for (int i = 0; i < this.isotopeMasses.length; ++i) {
            if (!(this.isotopeAbundances[i] > max)) continue;
            max = this.isotopeAbundances[i];
            mainMass = this.isotopeMasses[i];
        }
        return mainMass;
    }

    public void setCovalentRadius(double cov) {
        this.covalentRadius = cov;
    }

    public double getCovalentRadius() {
        return this.covalentRadius > 0.1 ? this.covalentRadius : 1.4;
    }

    public double getRadius(RadiusType radiusType) {
        double radius = Double.NaN;
        if (radiusType.equals((Object)RadiusType.ATOMIC)) {
            radius = this.getAtomicRadius();
        } else if (radiusType.equals((Object)RadiusType.COVALENT)) {
            radius = this.getCovalentRadius();
        } else if (!radiusType.equals((Object)RadiusType.IONIC) && radiusType.equals((Object)RadiusType.VDW)) {
            radius = this.getVDWRadius();
        }
        return radius;
    }

    public double getTypeAdjustedCovalentRadius() {
        double radius = this.getCovalentRadius();
        radius = this.isChemicalElementType(Type.ACTINIDE) || this.isChemicalElementType(Type.LANTHANIDE) ? (radius *= 1.35) : (this.isChemicalElementType(Type.TRANSITION_METAL) ? (radius *= 1.25) : (this.isChemicalElementType(Type.GROUP_B) || this.isChemicalElementType(Type.GROUP_A) ? (radius *= 1.2) : (radius *= 1.15)));
        return radius;
    }

    public void setAtomicRadius(double cov) {
        this.atomicRadius = cov;
    }

    public double getAtomicRadius() {
        return this.atomicRadius > 0.1 ? this.atomicRadius : 1.6;
    }

    public void setVDWRadius(double vdw) {
        this.vanderwaalsRadius = vdw;
    }

    public double getVDWRadius() {
        return this.vanderwaalsRadius > 0.1 ? this.vanderwaalsRadius : 2.0;
    }

    public void setElectronegativity(double eneg) {
        this.electronegativity = eneg;
    }

    public double getElectronegativity() {
        return this.electronegativity;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public String getColorString() {
        String blue;
        String green;
        String red = Integer.toHexString(this.color.getRed());
        if (red.length() == 1) {
            red = "0" + red;
        }
        if ((green = Integer.toHexString(this.color.getGreen())).length() == 1) {
            green = "0" + green;
        }
        if ((blue = Integer.toHexString(this.color.getBlue())).length() == 1) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    public int getValenceElectrons() {
        if (this.atomicNumber < 2) {
            return this.atomicNumber;
        }
        if (this.atomicNumber < 10) {
            return this.atomicNumber - 2;
        }
        if (this.atomicNumber < 18) {
            return this.atomicNumber - 10;
        }
        if (this.atomicNumber < 28) {
            return this.atomicNumber - 18;
        }
        if (this.atomicNumber < 36) {
            return this.atomicNumber - 28;
        }
        if (this.atomicNumber < 46) {
            return this.atomicNumber - 36;
        }
        if (this.atomicNumber < 54) {
            return this.atomicNumber - 46;
        }
        if (this.atomicNumber < 78) {
            return this.atomicNumber - 54;
        }
        if (this.atomicNumber < 86) {
            return this.atomicNumber - 78;
        }
        return -1;
    }

    public String toString() {
        return this.atomicSymbol + ": " + this.atomicWeight;
    }

    public void debug() {
        ChemicalElement.debug(this);
    }

    public boolean isChemicalElementType(Type type, int value) {
        int atNum = this.getAtomicNumber();
        boolean isType = false;
        if (type.equals((Object)Type.ROW)) {
            isType = value == 1 && atNum >= 3 && atNum <= 10 || value == 2 && atNum >= 11 && atNum <= 18 || value == 3 && atNum >= 19 && atNum <= 36 || value == 4 && atNum >= 37 && atNum <= 54 || value == 5 && atNum >= 55 && atNum <= 86 || value == 6 && atNum >= 87;
        } else if (type.equals((Object)Type.GROUP_A)) {
            if (value == 1 || value == 2) {
                isType = atNum == 2 + value || atNum == 10 + value || atNum == 18 + value || atNum == 36 + value || atNum == 54 + value;
            } else if (value >= 3 && value <= 8) {
                isType = atNum == 2 + value || atNum == 10 + value || atNum == 28 + value || atNum == 46 + value || atNum == 78 + value;
            }
        } else if (type.equals((Object)Type.GROUP_B)) {
            if (value >= 1 || value <= 10) {
                isType = atNum == 18 + value || atNum == 36 + value || atNum == 56 + value;
            }
        } else {
            throw new RuntimeException("Bad type for " + (Object)((Object)type) + ": " + value);
        }
        return isType;
    }

    public boolean isChemicalElementType(Type type) {
        int atNum = this.getAtomicNumber();
        boolean isType = false;
        if (type.equals((Object)Type.TRANSITION_METAL)) {
            isType = atNum > 20 && atNum <= 30 || atNum > 38 && atNum <= 48 || atNum > 56 && atNum <= 80;
        } else if (type.equals((Object)Type.LANTHANIDE)) {
            isType = atNum >= 58 && atNum <= 71;
        } else if (type.equals((Object)Type.ACTINIDE)) {
            isType = atNum >= 90 && atNum <= 103;
        } else if (type.equals((Object)Type.METAL)) {
            isType = this.isChemicalElementType(Type.TRANSITION_METAL) || this.isChemicalElementType(Type.LANTHANIDE) || this.isChemicalElementType(Type.ACTINIDE) || this.isChemicalElementType(Type.GROUP_A) || this.isChemicalElementType(Type.GROUP_B) || atNum == 13 || atNum >= 31 && atNum <= 32 || atNum >= 49 && atNum <= 51 || atNum >= 81 && atNum <= 84;
        } else if (type.equals((Object)Type.METAL_NOT_SEMI_METAL)) {
            isType = this.isChemicalElementType(Type.TRANSITION_METAL) || this.isChemicalElementType(Type.LANTHANIDE) || this.isChemicalElementType(Type.ACTINIDE) || this.isChemicalElementType(Type.GROUP_A) || this.isChemicalElementType(Type.GROUP_B);
        } else if (type.equals((Object)Type.NON_METAL)) {
            isType = atNum >= 5 && atNum <= 10 || atNum >= 14 && atNum <= 18 || atNum >= 33 && atNum <= 36 || atNum >= 52 && atNum <= 54 || atNum >= 85 && atNum <= 86;
        } else if (type.equals((Object)Type.PBLOCK)) {
            isType = atNum >= 5 && atNum <= 10 || atNum >= 14 && atNum <= 18 || atNum >= 32 && atNum <= 36 || atNum >= 53 && atNum <= 54;
        } else if (type.equals((Object)Type.GROUP_A)) {
            isType = atNum == 3 || atNum == 11 || atNum == 19 || atNum == 37 || atNum == 55 || atNum == 87;
        } else if (type.equals((Object)Type.GROUP_B)) {
            isType = atNum == 4 || atNum == 12 || atNum == 20 || atNum == 38 || atNum == 56 || atNum == 88;
        } else if (type.equals((Object)Type.SEMI_METAL)) {
            isType = atNum == 13 || atNum == 31 || atNum == 32 || atNum >= 49 && atNum <= 51 || atNum >= 81 && atNum <= 84;
        } else if (type.equals((Object)Type.HALOGEN)) {
            isType = atNum == 9 || atNum == 17 || atNum == 35 || atNum == 53 || atNum == 85;
        } else {
            throw new RuntimeException("Bad type for " + (Object)((Object)type));
        }
        return isType;
    }

    public static ChemicalElement getChemicalElementIgnoreCase(String symbol) {
        symbol = symbol.toUpperCase();
        return pTable.get(symbol);
    }

    public static ChemicalElement getChemicalElement(String symbol) {
        return pTable.get(symbol);
    }

    public static ChemicalElement getChemicalElement(AS as) {
        return pTable.get(as.value);
    }

    public static ChemicalElement grabChemicalElement(String s) {
        ChemicalElement element = null;
        if (s != null && s.length() != 0) {
            if (s.length() == 1) {
                element = ChemicalElement.getChemicalElement(s);
            } else {
                String ss = s.substring(0, 2);
                element = ChemicalElement.getChemicalElement(ss);
                if (element == null) {
                    element = ChemicalElement.getChemicalElement(s.substring(0, 1));
                }
            }
        }
        return element;
    }

    public static ChemicalElement getElement(int atomicNumber) {
        if (atomicNumber < 1 || atomicNumber >= 150) {
            return null;
        }
        return periodicTable[atomicNumber];
    }

    private static double getWeight(Element element, String source) {
        Elements weights = element.getChildElements("mass");
        for (int i = 0; i < weights.size(); ++i) {
            Element weight = weights.get(i);
            if (source == null || !source.equals(weight.getAttributeValue("source"))) continue;
            return Double.parseDouble(weight.getValue());
        }
        return 0.0;
    }

    private static double getRadius(Element element, String source, String type, String context) {
        Elements radiiList = element.getChildElements("radii");
        for (int i = 0; i < radiiList.size(); ++i) {
            Element radii = radiiList.get(i);
            if (source != null && !source.equals(radii.getAttributeValue("source"))) continue;
            Elements radiusList = radii.getChildElements("radius");
            for (int j = 0; j < radiusList.size(); ++j) {
                Element radius = radiusList.get(j);
                if (type == null || !type.equals(radius.getAttributeValue("type")) || context != null && !context.equals(radius.getAttributeValue("context"))) continue;
                double rad = Double.parseDouble(radius.getValue());
                if (radius.getAttributeValue("unit").equals("pm")) {
                    rad /= 100.0;
                }
                return rad;
            }
        }
        return 0.0;
    }

    private static double getElectronegativity(Element element, String source, String type) {
        Elements enegList = element.getChildElements("electronegativity");
        for (int i = 0; i < enegList.size(); ++i) {
            Element eneg = enegList.get(i);
            if (source == null || !source.equals(eneg.getAttributeValue("source")) || type == null || !type.equals(eneg.getAttributeValue("type"))) continue;
            return Double.parseDouble(eneg.getValue());
        }
        return 0.0;
    }

    private static String getElectronicState(Element element, String source, String type) {
        Elements eStates = element.getChildElements("electronicconfiguration");
        for (int i = 0; i < eStates.size(); ++i) {
            Element estate = eStates.get(i);
            if (source == null || !source.equals(estate.getAttributeValue("source")) || type == null || !type.equals(estate.getAttributeValue("type"))) continue;
            return estate.getValue();
        }
        return "";
    }

    public static void debug(ChemicalElement el) {
        logger.info((Object)"ChemicalElement:");
        logger.info((Object)(" > AS: " + el.getSymbol()));
        logger.info((Object)(" > Atomic number: " + el.getAtomicNumber()));
        logger.info((Object)(" > Group: " + el.getGroup()));
        logger.info((Object)(" > Period: " + el.getPeriod()));
        logger.info((Object)(" > Atomic weight: " + el.getAtomicWeight()));
        logger.info((Object)(" > Main isotope: " + el.getMainIsotope()));
        logger.info((Object)(" > Valence electrons: " + el.getValenceElectrons()));
        logger.info((Object)(" > Ground state config: " + el.getElectronicGroundState()));
        logger.info((Object)(" > Electronegativity: " + el.getElectronegativity()));
        logger.info((Object)(" > Atomic radius: " + el.getAtomicRadius()));
        logger.info((Object)(" > Covalent radius: " + el.getCovalentRadius()));
        logger.info((Object)(" > Van-der-Waal's radius: " + el.getVDWRadius()));
        logger.info((Object)" > Isotopes:");
        int[] isoMass = el.getIsotopeMasses();
        double[] isoAbun = el.getIsotopeAbundances();
        for (int i = 0; i < isoMass.length; ++i) {
            logger.info((Object)(" >     " + isoMass[i] + " (" + isoAbun[i] + "%)"));
        }
        logger.info((Object)(" > Color: " + el.getColor().toString()));
        logger.info((Object)"----------------------------------------");
    }

    public static double getBondingRadiusTolerance() {
        return bondingRadiusTolerance;
    }

    public static void setBondingRadiusTolerance(double tol) {
        bondingRadiusTolerance = tol > 0.0 ? tol : bondingRadiusTolerance;
    }

    public static Set<ChemicalElement> getElementSet(String[] symbols) {
        ArrayList<String> symbolList = new ArrayList<String>();
        for (String symbol : symbols) {
            symbolList.add(symbol);
        }
        return ChemicalElement.getElementSet(symbolList);
    }

    public static Set<ChemicalElement> getElementSet(List<String> symbolList) {
        HashSet<ChemicalElement> set = new HashSet<ChemicalElement>();
        for (String symbol : symbolList) {
            ChemicalElement element = ChemicalElement.getChemicalElement(symbol);
            if (element == null) continue;
            set.add(element);
        }
        return set;
    }

    static {
        Document document = null;
        try {
            document = CMLUtil.getXMLResource(ELEMENT_FILE);
        }
        catch (IOException e1) {
            throw new RuntimeException("BUG: cannot read PT resource file: org/xmlcml/molutil/elementdata.xml");
        }
        document = null;
        try {
            document = CMLUtil.getXMLResource(ELEMENT_FILE);
        }
        catch (IOException e1) {
            throw new RuntimeException("BUG: cannot read PT resource file: org/xmlcml/molutil/elementdata.xml");
        }
        Elements elements = document.getRootElement().getChildElements("element");
        for (int i = 0; i < elements.size(); ++i) {
            Element node;
            Elements isotopes;
            Element element = elements.get(i);
            String symbol = element.getAttributeValue("id");
            int atNum = Integer.parseInt(element.getAttributeValue("atomicnumber"));
            double atWeight = ChemicalElement.getWeight(element, "webelements");
            ChemicalElement el = new ChemicalElement(symbol, atNum, atWeight);
            pTable.put(el.atomicSymbol, el);
            String sGroup = element.getAttributeValue("group");
            el.group = sGroup != null ? Integer.parseInt(sGroup) : 0;
            String sPeriod = element.getAttributeValue("period");
            el.period = sPeriod != null ? Integer.parseInt(sPeriod) : 0;
            double d = ChemicalElement.getRadius(element, "webelements", "covalent", "empirical");
            el.setCovalentRadius(d);
            d = ChemicalElement.getRadius(element, "webelements", "atomic", "empirical");
            el.setAtomicRadius(d);
            d = ChemicalElement.getRadius(element, "webelements", "vanderwaals", null);
            el.setVDWRadius(d);
            el.setElectronegativity(ChemicalElement.getElectronegativity(element, "webelements", "pauling"));
            el.electronicGroundState = ChemicalElement.getElectronicState(element, "webelements", "groundstate");
            Elements nodelist = element.getChildElements("isotopes");
            int[] ii = new int[]{};
            double[] aa = new double[]{};
            double[] preciseMasses = new double[]{};
            if (nodelist.size() > 0 && (isotopes = (node = nodelist.get(0)).getChildElements("isotope")).size() > 0) {
                ii = new int[isotopes.size()];
                aa = new double[isotopes.size()];
                preciseMasses = new double[isotopes.size()];
                for (int j = 0; j < isotopes.size(); ++j) {
                    Element isotope = isotopes.get(j);
                    try {
                        ii[j] = Integer.parseInt(isotope.getAttributeValue("mass"));
                        aa[j] = Double.parseDouble(isotope.getAttributeValue("abundance"));
                        String preciseMass = isotope.getAttributeValue("preciseMass");
                        if (preciseMass == null) {
                            preciseMasses[j] = Double.NaN;
                            continue;
                        }
                        preciseMasses[j] = Double.parseDouble(preciseMass);
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
            el.addIsotope(ii, aa);
            el.setIsotopePreciseMasses(preciseMasses);
            nodelist = element.getChildElements("rgb");
            if (nodelist.size() <= 0) continue;
            node = nodelist.get(0);
            float red = Float.parseFloat(node.getAttributeValue("red"));
            float green = Float.parseFloat(node.getAttributeValue("green"));
            float blue = Float.parseFloat(node.getAttributeValue("blue"));
            el.setColor(new Color(red, green, blue));
        }
    }

    public static enum RadiusType {
        ATOMIC,
        COVALENT,
        IONIC,
        VDW;

    }

    public static enum Type {
        TRANSITION_METAL,
        PBLOCK,
        METAL,
        METAL_NOT_SEMI_METAL,
        GROUP_A,
        GROUP_B,
        ROW,
        LANTHANIDE,
        ACTINIDE,
        NON_METAL,
        SEMI_METAL,
        HALOGEN;

    }

    public static enum AS {
        H("H", 1),
        He("He", 2),
        Li("Li", 3),
        Be("Be", 4),
        B("B", 5),
        C("C", 6),
        N("N", 7),
        O("O", 8),
        F("F", 9),
        Ne("Ne", 10),
        Na("Na", 11),
        Mg("Mg", 12),
        Al("Al", 13),
        Si("Si", 14),
        P("P", 15),
        S("S", 16),
        Cl("Cl", 17),
        Ar("Ar", 18),
        Br("Br", 35),
        I("I", 53),
        R("R", 119);

        public String value;
        public int n;

        private AS(String symbol, int n2) {
            this.value = symbol;
            this.n = n2;
        }

        public boolean equals(String elSym) {
            return elSym != null && elSym.equals(this.value);
        }
    }
}

