/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid.util;

import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Node;
import org.xmlcml.xml.XMLUtil;

public class MultisetUtil {
    public static Iterable<Multiset.Entry<String>> getEntriesSortedByCount(Multiset<String> wordSet) {
        return Multisets.copyHighestCountFirst(wordSet).entrySet();
    }

    public static Iterable<Multiset.Entry<String>> getEntriesSortedByValue(Multiset<String> wordSet) {
        return ImmutableSortedMultiset.copyOf(wordSet).entrySet();
    }

    public static Iterable<Multiset.Entry<Integer>> getIntegerEntriesSortedByValue(Multiset<Integer> integerSet) {
        return ImmutableSortedMultiset.copyOf(integerSet).entrySet();
    }

    public static Iterable<Multiset.Entry<Integer>> getIntegerEntriesSortedByCount(Multiset<Integer> integerSet) {
        return Multisets.copyHighestCountFirst(integerSet).entrySet();
    }

    public static Iterable<Multiset.Entry<Double>> getDoubleEntriesSortedByValue(Multiset<Double> doubleSet) {
        return ImmutableSortedMultiset.copyOf(doubleSet).entrySet();
    }

    public static Iterable<Multiset.Entry<Double>> getDoubleEntriesSortedByCount(Multiset<Double> doubleSet) {
        return Multisets.copyHighestCountFirst(doubleSet).entrySet();
    }

    public static List<String> getAttributeValues(Node searchNode, String xpath) {
        List<Node> nodes = XMLUtil.getQueryNodes(searchNode, xpath);
        ArrayList<String> nodeValues = new ArrayList<String>();
        for (Node node : nodes) {
            String value = node.getValue();
            if (value == null || value.trim().length() == 0) continue;
            nodeValues.add(value);
        }
        return nodeValues;
    }
}

