/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.stml;

import nu.xom.Attribute;
import nu.xom.NamespaceConflictException;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.xmlcml.stml.STMLType;
import org.xmlcml.xml.XMLConstants;

public class STMLAttribute
extends Attribute
implements XMLConstants {
    static final Logger logger = Logger.getLogger(STMLAttribute.class);
    public static final String CONSTANT_TO_SI = "constantToSI";
    public static final String CONVENTION = "convention";
    public static final String DICTREF = "dictRef";
    public static final String ID = "id";
    public static final String MULTIPLIER_TO_SI = "multiplierToSI";
    public static final String TITLE = "title";
    public static final String UNITS = "units";
    protected STMLType cmlType;
    protected String summary;
    protected String description;
    protected String attributeGroupName;

    public STMLAttribute(String name) {
        super(name, "");
    }

    public STMLAttribute(String name, String value) {
        super(name, value);
    }

    protected STMLAttribute(String name, String URI2, String value) throws NamespaceConflictException {
        super(name, URI2, value);
    }

    public STMLAttribute(STMLAttribute att) {
        super((Attribute)att);
        this.cmlType = att.cmlType;
    }

    public STMLAttribute(Attribute att) {
        super(att);
    }

    protected STMLAttribute(Attribute att, String value) {
        this(att.getLocalName());
        this.setSTMLValue(value);
    }

    public Node copy() {
        STMLAttribute newAttribute = new STMLAttribute(this);
        newAttribute.setValue(this.getValue());
        return newAttribute;
    }

    public void setAttributeGroupName(String agn) {
        this.attributeGroupName = agn;
    }

    public String getAttributeGroupName() {
        return this.attributeGroupName;
    }

    public int compareTo(Attribute att) {
        if (att == null) {
            return -1;
        }
        if (this == att) {
            return 0;
        }
        int order = 0;
        if (!(att instanceof STMLAttribute)) {
            order = -1;
        }
        STMLAttribute cmlAtt = (STMLAttribute)att;
        if (order != -1 && (this.cmlType != null || cmlAtt.cmlType != null)) {
            order = this.cmlType != null && cmlAtt.cmlType != null ? this.cmlType.compareTo(cmlAtt.cmlType) : -1;
        }
        if (order == 0) {
            order = this.getClass().getName().compareTo(att.getClass().getName());
        }
        if (order == 0) {
            order = this.getLocalName().compareTo(cmlAtt.getLocalName());
        }
        if (order == 0) {
            order = this.getValue().compareTo(cmlAtt.getValue());
        }
        return order == 0 ? 0 : order / Math.abs(order);
    }

    public String getJavaType() {
        return "String";
    }

    public String getJavaSetMethod() {
        return "setSTMLValue";
    }

    public String getJavaGetMethod() {
        return "getSTMLValue";
    }

    public String getJavaShortClassName() {
        return this.getClass().getSimpleName();
    }

    public STMLType getSchemaType() {
        return this.cmlType;
    }

    public void setSchemaType(STMLType schemaType) {
        this.cmlType = schemaType;
    }

    public Object getSTMLValue() {
        return this.getValue();
    }

    public void setSTMLValue(String s) {
        this.setValue(s);
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String s) {
        if (s != null) {
            this.summary = s;
            if (!this.summary.endsWith(".")) {
                this.summary = this.summary + ".";
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public STMLType getCmlType() {
        return this.cmlType;
    }

    public void setCmlType(STMLType cmlType) {
        this.cmlType = cmlType;
    }
}

