/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.stml;

import java.text.ParseException;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.xmlcml.euclid.JodaDate;
import org.xmlcml.euclid.Util;
import org.xmlcml.stml.STMLAttribute;
import org.xmlcml.stml.STMLElement;
import org.xmlcml.stml.STMLType;
import org.xmlcml.stml.attribute.DictRefAttribute;
import org.xmlcml.stml.attribute.NamespaceRefAttribute;
import org.xmlcml.stml.interfacex.HasDataType;
import org.xmlcml.stml.interfacex.HasDictRef;
import org.xmlcml.stml.interfacex.HasScalar;
import org.xmlcml.stml.interfacex.HasUnits;

public class STMLScalar
extends STMLElement
implements HasUnits,
HasScalar,
HasDictRef,
HasDataType {
    private static Logger LOG = Logger.getLogger(STMLScalar.class);
    public static final String TAG = "scalar";

    public STMLScalar() {
        super(TAG);
        this.init();
    }

    void init() {
    }

    public STMLScalar(STMLScalar old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new STMLScalar(this);
    }

    public STMLScalar(Boolean scalar) {
        this.setValue(scalar);
    }

    public STMLScalar(DateTime scalar) {
        this.setValue(scalar);
    }

    public STMLScalar(String scalar) {
        this();
        this.setValue(scalar);
    }

    public STMLScalar(double scalar) {
        this.setValue(scalar);
    }

    public STMLScalar(int scalar) {
        this.setValue(scalar);
    }

    public Boolean getBoolean() {
        String content;
        Boolean result = null;
        if (this.getDataType().equals("xsd:boolean") && (content = this.getXMLContent()) != null) {
            result = new Boolean(content);
        }
        return result;
    }

    public DateTime getDate() {
        String content;
        DateTime result = null;
        if (this.getDataType().equals("xsd:date") && (content = this.getXMLContent()) != null) {
            try {
                result = JodaDate.parseDate(content);
            }
            catch (Exception e) {
                throw new RuntimeException("bad date", e);
            }
        }
        return result;
    }

    @Override
    public double getDouble() {
        String content;
        double result = Double.NaN;
        if (this.getDataType().equals("xsd:double") && (content = this.getXMLContent()) != null) {
            try {
                result = Util.parseFlexibleDouble(content);
            }
            catch (ParseException e) {
                throw new RuntimeException("Bad double :" + content, e);
            }
        }
        return result;
    }

    @Override
    public String getString() {
        String result = null;
        if (this.getDataType().equals("xsd:string")) {
            result = this.getXMLContent();
        }
        return result;
    }

    @Override
    public int getInt() {
        int result = Integer.MIN_VALUE;
        if (this.getDataType().equals("xsd:integer")) {
            String content = this.getXMLContent();
            if (content != null && !content.trim().equals("")) {
                try {
                    result = Integer.parseInt(content);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("bad integer content: " + content);
                }
            }
        } else {
            throw new RuntimeException("wrong dataType for int " + this.getDataType());
        }
        return result;
    }

    public void setValue(Boolean scalar) {
        this.setXMLContent("" + scalar);
        super.setDataType("xsd:boolean");
    }

    public void setValue(DateTime scalar) {
        String date = JodaDate.formatDate(scalar);
        this.setXMLContent(date);
        super.setDataType("xsd:date");
    }

    public void setValue(String scalar) {
        if (scalar != null) {
            this.setXMLContent(scalar);
            super.setDataType("xsd:string");
        }
    }

    public void setValueNoTrim(String scalar) {
        if (scalar != null) {
            this.removeChildren();
            this.appendChild(scalar);
            this.setDataType("xsd:string");
        }
    }

    public void setValue(double scalar) {
        this.setXMLContent("" + scalar);
        super.setDataType("xsd:double");
    }

    public void setValue(int scalar) {
        this.setXMLContent("" + scalar);
        super.setDataType("xsd:integer");
    }

    @Override
    public String getDataType() {
        String dataType = super.getDataType();
        if (dataType == null) {
            dataType = "xsd:string";
            super.setDataType(dataType);
        }
        return STMLType.getNormalizedValue(dataType);
    }

    public Class<?> getDataTypeClass() {
        Class clazz = null;
        String dataType = this.getDataType();
        if ("xsd:string".equals(dataType)) {
            clazz = String.class;
        } else if ("xsd:double".equals(dataType)) {
            clazz = Double.class;
        } else if ("xsd:integer".equals(dataType)) {
            clazz = Integer.class;
        } else if ("xsd:boolean".equals(dataType)) {
            clazz = Boolean.class;
        } else if ("xsd:date".equals(dataType)) {
            clazz = DateTime.class;
        }
        return clazz;
    }

    @Override
    public void setDataType(String dType) {
        if (this.getAttributeValue("dataType") != null) {
            throw new RuntimeException("Must not reset dataType; use SetValue(...)");
        }
        super.setDataType(dType);
    }

    void checkNumericConformability(STMLScalar scalar) {
        if (!this.getDataType().equals(scalar.getDataType())) {
            throw new RuntimeException("Unsuitable dataTypes for numeric operations / " + this.getDataType() + "/" + scalar.getDataType());
        }
    }

    public STMLScalar subtract(STMLScalar scalar) {
        this.checkNumericConformability(scalar);
        STMLScalar resultScalar = null;
        if (this.getDataType().equals("xsd:double")) {
            resultScalar = new STMLScalar(this.getDouble() - scalar.getDouble());
        } else if (this.getDataType().equals("xsd:integer")) {
            resultScalar = new STMLScalar(this.getInt() - scalar.getInt());
        }
        return resultScalar;
    }

    public void subtractEquals(STMLScalar scalar) {
        this.checkNumericConformability(scalar);
        if (this.getDataType().equals("xsd:double")) {
            this.setValue(this.getDouble() - scalar.getDouble());
        } else if (this.getDataType().equals("xsd:integer")) {
            this.setValue(this.getInt() - scalar.getInt());
        }
    }

    public STMLScalar plus(STMLScalar scalar) {
        this.checkNumericConformability(scalar);
        STMLScalar resultScalar = null;
        if (this.getDataType().equals("xsd:double")) {
            resultScalar = new STMLScalar(this.getDouble() + scalar.getDouble());
        } else if (this.getDataType().equals("xsd:integer")) {
            resultScalar = new STMLScalar(this.getInt() + scalar.getInt());
        }
        return resultScalar;
    }

    public void plusEquals(STMLScalar scalar) {
        this.checkNumericConformability(scalar);
        if (this.getDataType().equals("xsd:double")) {
            this.setValue(this.getDouble() + scalar.getDouble());
        } else if (this.getDataType().equals("xsd:integer")) {
            this.setValue(this.getInt() + scalar.getInt());
        }
    }

    public DictRefAttribute getDictRefFromElementOrParent() {
        return DictRefAttribute.getDictRefFromElementOrParent(this);
    }

    @Override
    public void setUnits(String prefix, String id, String namespaceURI) {
        NamespaceRefAttribute.setUnits(this, prefix, id, namespaceURI);
    }

    public Double getNumberAsDouble() {
        Double d = this.getDouble();
        if (d == null || Double.isNaN(d)) {
            try {
                Integer i = this.getInt();
                d = (double)i;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    @Override
    public String getUnits() {
        return this.getAttributeValue("units");
    }

    @Override
    public STMLAttribute getDataTypeAttribute() {
        return (STMLAttribute)this.getAttribute("dataType");
    }
}

