/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.Complex;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.Real2;

public class Polar
implements EuclidConstants {
    double r = 0.0;
    double theta = 0.0;

    public Polar() {
    }

    public Polar(double x, double y) {
        this.r = Math.sqrt(x * x + y * y);
        this.theta = Math.atan2(y, x);
    }

    public Polar(double a, Angle b) {
        this.r = a;
        this.theta = b.getAngle();
    }

    public Polar(Complex c) {
        this.r = c.getR();
        this.theta = c.getTheta().getAngle();
    }

    public Polar(Polar a) {
        this.r = a.r;
        this.theta = a.theta;
    }

    public double getR() {
        return this.r;
    }

    public Angle getTheta() {
        return new Angle(this.theta);
    }

    public Polar plus(Polar a2) {
        Complex tmp = new Complex(this.getX() + a2.getX(), this.getY() + a2.getY());
        Polar temp = new Polar(tmp);
        return temp;
    }

    public Polar subtract(Polar a2) {
        Complex tmp = new Complex(this.getX() - a2.getX(), this.getY() - a2.getY());
        Polar temp = new Polar(tmp);
        return temp;
    }

    public void subtract() {
        this.theta += Math.PI;
    }

    public Polar multiplyBy(Polar f) {
        Polar temp = new Polar(this);
        temp.r = this.r * f.r;
        temp.theta = this.theta + f.theta;
        return temp;
    }

    public Polar multiplyBy(double f) {
        Polar temp = new Polar(this);
        temp.r *= f;
        return temp;
    }

    public Polar divideBy(Polar f) throws EuclidRuntimeException {
        Polar temp = new Polar(this);
        if (Real.isZero(f.r, Real.getEpsilon())) {
            throw new EuclidRuntimeException();
        }
        temp.r = this.r / f.r;
        temp.theta = this.theta - f.theta;
        return temp;
    }

    public boolean isEqualTo(Polar a) {
        return Real.isEqual(this.r, a.r) && Real.isEqual(this.theta, a.theta);
    }

    public double getX() {
        double temp = this.r * Math.cos(this.theta);
        return temp;
    }

    public double getY() {
        double temp = this.r * Math.sin(this.theta);
        return temp;
    }

    public Real2 getXY() {
        return new Real2(this.r * Math.cos(this.theta), this.r * Math.sin(this.theta));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Polar: " + this.r + "," + this.theta);
        return sb.toString();
    }
}

