/*
 * Decompiled with CFR 0.152.
 */
package org.bongiorno.misc.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bongiorno.misc.collections.ImprovedList;
import org.bongiorno.misc.collections.ImprovedMap;
import org.bongiorno.misc.collections.ImprovedStream;
import org.bongiorno.misc.collections.QuickCollection;

public interface ImprovedCollection<T>
extends Collection<T>,
Serializable {
    default public <K> Map<K, ImprovedList<T>> groupingBy(Function<? super T, ? extends K> classifier) {
        return this.stream().collect(Collectors.groupingBy(classifier, Collectors.toCollection(ImprovedList::new)));
    }

    default public <R> ImprovedStream<R> map(Function<? super T, ? extends R> mapper) {
        return ImprovedStream.improve(this.stream().map(mapper));
    }

    default public <R> ImprovedStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new ImprovedStream(this.stream().flatMap(mapper));
    }

    public static <T> ImprovedCollection<T> of(Collection<T> sadCollection) {
        return new QuickCollection<T>(sadCollection);
    }

    public static <T> ImprovedCollection<T> improve(Collection<T> sadCollection) {
        return new QuickCollection<T>(sadCollection);
    }

    default public <K> ImprovedMap<K, T> toMap(Function<? super T, ? extends K> classifier) {
        return this.stream().collect(Collectors.toMap(classifier, Function.identity(), ImprovedCollection.noDupKeys(), ImprovedMap::new));
    }

    default public <K, U> ImprovedMap<K, U> toMap(Function<? super T, ? extends K> fOfK, Function<? super T, ? extends U> fOfV) {
        return this.stream().collect(Collectors.toMap(fOfK, fOfV, ImprovedCollection.noDupKeys(), ImprovedMap::new));
    }

    default public <O> ImprovedCollection<O> transform(Function<? super T, ? extends O> f, Supplier<ImprovedCollection<O>> s) {
        return this.map(f).collect(Collectors.toCollection(s));
    }

    default public ImprovedStream<T> filter(Predicate<T> p) {
        return new ImprovedStream(this.stream().filter(p));
    }

    default public boolean anyMatch(Predicate<? super T> predicate) {
        return this.stream().anyMatch(predicate);
    }

    public static <T> BinaryOperator<T> noDupKeys() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }
}

