/*
 * Decompiled with CFR 0.152.
 */
package org.bongiorno.misc.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bongiorno.misc.collections.ImprovedStream;
import org.bongiorno.misc.collections.QuickCollection;

public class ImprovedList<T>
extends QuickCollection<T>
implements List<T> {
    public ImprovedList() {
        super(new ArrayList());
    }

    public ImprovedList(List<T> interiorDelegate) {
        super(interiorDelegate);
    }

    public static <T> ImprovedList<T> improve(List<T> inferiorList) {
        return new ImprovedList<T>(inferiorList);
    }

    public static <T> ImprovedList<T> of(List<T> inferiorList) {
        return new ImprovedList<T>(inferiorList);
    }

    @SafeVarargs
    public static <T> ImprovedList<T> of(T ... stuff) {
        return new ImprovedList<T>(new ArrayList<T>(Arrays.asList(stuff)));
    }

    public <O> ImprovedList<O> transform(Function<? super T, ? extends O> f) {
        return this.stream().map(f).collect(Collectors.toCollection(ImprovedList::new));
    }

    @Override
    public void add(int index, T element) {
        ((List)this.delegate).add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return ((List)this.delegate).addAll(index, c);
    }

    @Override
    public T get(int index) {
        return (T)((List)this.delegate).get(index);
    }

    @Override
    public T set(int index, T element) {
        return ((List)this.delegate).set(index, element);
    }

    @Override
    public T remove(int index) {
        return (T)((List)this.delegate).remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return ((List)this.delegate).indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ((List)this.delegate).lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return ((List)this.delegate).listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return ((List)this.delegate).listIterator(index);
    }

    @Override
    public ImprovedList<T> subList(int fromIndex, int toIndex) {
        return new ImprovedList<T>((List)this.delegate).subList(fromIndex, toIndex);
    }

    public ImprovedList<T> subList(int fromIndex) {
        return new ImprovedList(((List)this.delegate).subList(fromIndex, this.size()));
    }

    public static class ImprovedListStream<T>
    extends ImprovedStream<T> {
        public ImprovedListStream(ImprovedStream<T> delegate) {
            super(delegate);
        }

        public <O> ImprovedList<O> transform(Function<? super T, ? extends O> f) {
            return this.delegate.map(f).collect(Collectors.toCollection(ImprovedList::new));
        }

        public ImprovedList<T> collect() {
            return this.delegate.collect(Collectors.toCollection(ImprovedList::new));
        }
    }
}

