/*
 * Decompiled with CFR 0.152.
 */
package org.bongiorno.misc.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bongiorno.misc.collections.ImprovedStream;
import org.bongiorno.misc.collections.QuickCollection;

public class ImprovedSet<T>
extends QuickCollection<T>
implements Set<T> {
    public ImprovedSet() {
        super(new HashSet());
    }

    public ImprovedSet(Collection<T> sadCollection) {
        super(new HashSet<T>(sadCollection));
    }

    public ImprovedSet(Set<T> sadDelegate) {
        super(sadDelegate);
    }

    public static <T> ImprovedSet<T> of(Set<T> sadSet) {
        return new ImprovedSet<T>(sadSet);
    }

    @SafeVarargs
    public static <T> ImprovedSet<T> of(T ... stuff) {
        return new ImprovedSet<T>(new HashSet<T>(Arrays.asList(stuff)));
    }

    public <O> ImprovedSet<O> transform(Function<? super T, ? extends O> f) {
        return this.stream().map(f).collect(Collectors.toCollection(ImprovedSet::new));
    }

    @Override
    public ImprovedSetStream<T> filter(Predicate<T> p) {
        return new ImprovedSetStream(super.filter(p));
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static class ImprovedSetStream<T>
    extends ImprovedStream<T> {
        private ImprovedSetStream(ImprovedStream<T> delegate) {
            super(delegate);
        }

        public <O> ImprovedSet<O> transform(Function<? super T, ? extends O> f) {
            return this.delegate.map(f).collect(Collectors.toCollection(ImprovedSet::new));
        }

        public ImprovedSet<T> collect() {
            return this.delegate.collect(Collectors.toCollection(ImprovedSet::new));
        }
    }
}

