/*
 * Decompiled with CFR 0.152.
 */
package org.bongiorno.misc.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.bongiorno.misc.collections.ImprovedList;
import org.bongiorno.misc.collections.ImprovedSet;

public class ImprovedStream<T>
implements Stream<T> {
    protected Stream<T> delegate;

    public ImprovedStream(Stream<T> delegate) {
        this.delegate = delegate;
    }

    public static <T> ImprovedStream<T> improve(Stream<T> inferiorStream) {
        return new ImprovedStream<T>(inferiorStream);
    }

    @Override
    public ImprovedList<T> toList() {
        return this.delegate.collect(Collectors.toCollection(ImprovedList::new));
    }

    public ImprovedSet<T> toSet() {
        return this.delegate.collect(Collectors.toCollection(ImprovedSet::new));
    }

    @Override
    public <R> ImprovedStream<R> map(Function<? super T, ? extends R> mapper) {
        return new ImprovedStream<R>(this.delegate.map(mapper));
    }

    public <K> Map<K, T> toMap(Function<? super T, ? extends K> classifier) {
        return this.delegate.collect(Collectors.toMap(classifier, Function.identity()));
    }

    @SafeVarargs
    public static <T> ImprovedStream<T> of(T ... things) {
        return new ImprovedStream<T>(Stream.of(things));
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.delegate.allMatch(predicate);
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.delegate.anyMatch(predicate);
    }

    public static <T1> Stream.Builder<T1> builder() {
        return Stream.builder();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.delegate.collect(collector);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.delegate.collect(supplier, accumulator, combiner);
    }

    public static <T1> Stream<T1> concat(Stream<? extends T1> a, Stream<? extends T1> b) {
        return Stream.concat(a, b);
    }

    @Override
    public long count() {
        return this.delegate.count();
    }

    @Override
    public Stream<T> distinct() {
        return this.delegate.distinct();
    }

    public static <T1> Stream<T1> empty() {
        return Stream.empty();
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        return this.delegate.filter(predicate);
    }

    @Override
    public Optional<T> findAny() {
        return this.delegate.findAny();
    }

    @Override
    public Optional<T> findFirst() {
        return this.delegate.findFirst();
    }

    @Override
    public <R> ImprovedStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new ImprovedStream(this.delegate.flatMap(mapper));
    }

    public <K> Map<K, ImprovedList<T>> groupingBy(Function<? super T, ? extends K> classifier) {
        return this.delegate.collect(Collectors.groupingBy(classifier, Collectors.toCollection(ImprovedList::new)));
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.delegate.flatMapToDouble(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.delegate.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.delegate.flatMapToLong(mapper);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.delegate.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.delegate.forEachOrdered(action);
    }

    public static <T1> Stream<T1> generate(Supplier<T1> s) {
        return Stream.generate(s);
    }

    @Override
    public boolean isParallel() {
        return this.delegate.isParallel();
    }

    public static <T1> Stream<T1> iterate(T1 seed, UnaryOperator<T1> f) {
        return Stream.iterate(seed, f);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Stream<T> limit(long maxSize) {
        return this.delegate.limit(maxSize);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.delegate.mapToDouble(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.delegate.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.delegate.mapToLong(mapper);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.delegate.max(comparator);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.delegate.min(comparator);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.delegate.noneMatch(predicate);
    }

    public static <T1> Stream<T1> of(T1 t1) {
        return Stream.of(t1);
    }

    @Override
    public Stream<T> onClose(Runnable closeHandler) {
        return (Stream)this.delegate.onClose(closeHandler);
    }

    @Override
    public Stream<T> parallel() {
        return (Stream)this.delegate.parallel();
    }

    @Override
    public Stream<T> peek(Consumer<? super T> action) {
        return this.delegate.peek(action);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.delegate.reduce(accumulator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.delegate.reduce(identity, accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.delegate.reduce(identity, accumulator, combiner);
    }

    @Override
    public Stream<T> sequential() {
        return (Stream)this.delegate.sequential();
    }

    @Override
    public Stream<T> skip(long n) {
        return this.delegate.skip(n);
    }

    @Override
    public Stream<T> sorted() {
        return this.delegate.sorted();
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        return this.delegate.sorted(comparator);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.delegate.toArray(generator);
    }

    @Override
    public Stream<T> unordered() {
        return (Stream)this.delegate.unordered();
    }
}

