/*
 * Decompiled with CFR 0.152.
 */
package org.bongiorno.misc.collections;

import java.util.Map;
import java.util.function.Function;
import org.bongiorno.misc.collections.QuickMap;

public class SuperTypeSearchingLazyMap<V>
extends QuickMap<Class<?>, V> {
    private Function<Class<?>, V> SEARCH_FUNCTION = clazz -> {
        Object result = null;
        if (clazz != null) {
            result = null;
            Class<?>[] iFaces = clazz.getInterfaces();
            for (int i = 0; i < iFaces.length && result == null; ++i) {
                result = this.get(iFaces[i]);
            }
            if (result == null) {
                result = this.get(clazz.getSuperclass());
            }
        }
        return result;
    };

    public SuperTypeSearchingLazyMap() {
    }

    public SuperTypeSearchingLazyMap(Map<Class<?>, V> delegate) {
        super(delegate);
    }

    @Override
    public V get(Object key) {
        Object result = super.get(key);
        if (result == null && (result = this.SEARCH_FUNCTION.apply((Class)key)) != null) {
            this.put((Class)key, result);
        }
        return result;
    }
}

