/*
 * Decompiled with CFR 0.152.
 */
package org.bongiorno.misc.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import org.bongiorno.misc.collections.QuickCollection;
import org.bongiorno.misc.collections.QuickMap;

public final class WSCollections {
    public static <K, V> Map<K, V> exceptionOnDuplicateMap(Map<K, V> m) {
        return new ExceptionOnDuplicateKeyMap(m);
    }

    public static <K, V> SortedMap<K, V> exceptionOnDuplicateSortedMap(SortedMap<K, V> m) {
        return new ExceptionOnDuplicateKeySortedMap(m);
    }

    public static <T> Collection<T> delimitedCollection(Collection<T> c, String delimiter) {
        return new DelimitedCollection(c, delimiter);
    }

    public static <T> Collection<T> delimitNewLine(Collection<T> c) {
        return new DelimitedCollection(c, System.lineSeparator());
    }

    public static <K, V> Map<K, V> delimitedMap(Map<K, V> m, CharSequence postKeyDelim, CharSequence postValueDelim) {
        return new DelimitedMap((Map)m, postKeyDelim, postValueDelim);
    }

    public static <K, V> Map<K, V> delimitedMap(Map<K, V> m, CharSequence preKey, CharSequence postKey, CharSequence postValue) {
        return new DelimitedMap(m, preKey, postKey, postValue);
    }

    public static <K, V> Map<K, V> delimitedMap(Map<K, V> m, CharSequence preKey, CharSequence postKey, CharSequence postValue, boolean trim) {
        return new DelimitedMap(m, preKey, postKey, postValue, trim);
    }

    public static <T> Set<T> exceptionOnDuplicateSet(Set<T> s) {
        return new ExceptionOnDuplicateSet(s);
    }

    public static <T> Map<T, T> asMap(T ... pairs) throws ArrayIndexOutOfBoundsException {
        HashMap<T, T> retVal = new HashMap<T, T>();
        int i = 0;
        while (i < pairs.length) {
            retVal.put(pairs[i++], pairs[i++]);
        }
        return retVal;
    }

    public static <K, V> Map<K, V> putInMap(Iterable<K> things, Function<? super K, V> valueFunction) {
        return WSCollections.putInMap(things, new HashMap(), valueFunction);
    }

    public static <K, V> Map<K, V> putInMap(Iterable<K> things, V value) {
        return WSCollections.putInMap(things, new HashMap(), value);
    }

    public static <C extends Map<K, V>, K, V> C putInMap(Iterable<K> things, C destinationMap, Function<? super K, V> valueFunction) {
        for (K thing : things) {
            destinationMap.put(thing, valueFunction.apply(thing));
        }
        return destinationMap;
    }

    public static <C extends Map<K, V>, K, V> C putInMap(Iterable<K> things, C destinationMap, V value) {
        return WSCollections.putInMap(things, destinationMap, k -> value);
    }

    private static class ExceptionOnDuplicateKeySortedMap<K, V>
    extends ExceptionOnDuplicateKeyMap<K, V>
    implements SortedMap<K, V> {
        private SortedMap<K, V> delegate = null;

        private ExceptionOnDuplicateKeySortedMap(SortedMap<K, V> delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.delegate.comparator();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.delegate.subMap(fromKey, toKey);
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return this.delegate.headMap(toKey);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return this.delegate.tailMap(fromKey);
        }

        @Override
        public K firstKey() {
            return this.delegate.firstKey();
        }

        @Override
        public K lastKey() {
            return this.delegate.lastKey();
        }
    }

    private static class DelimitedMap<K, V>
    extends QuickMap<K, V> {
        private CharSequence preKeyDelim = "";
        private CharSequence postKeyDelim = "";
        private CharSequence postValueDelim = "";
        private boolean trim = false;

        private DelimitedMap(Map<K, V> delegate, CharSequence preKeyDelim, CharSequence postKeyDelim, CharSequence postValueDelim, boolean trim) {
            super(delegate);
            this.delegate = delegate;
            this.preKeyDelim = preKeyDelim;
            this.postKeyDelim = postKeyDelim;
            this.postValueDelim = postValueDelim;
            this.trim = trim;
        }

        private DelimitedMap(Map<K, V> delegate, CharSequence preKeyDelim, CharSequence postKeyDelim, CharSequence postValueDelim) {
            super(delegate);
            this.delegate = delegate;
            this.preKeyDelim = preKeyDelim;
            this.postKeyDelim = postKeyDelim;
            this.postValueDelim = postValueDelim;
        }

        private DelimitedMap(Map<K, V> delegate, CharSequence postKey, CharSequence postValue) {
            super(delegate);
            this.delegate = delegate;
            this.postKeyDelim = postKey;
            this.postValueDelim = postValue;
        }

        public void setTrimming(boolean onOrOff) {
            this.trim = onOrOff;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry item : this.entrySet()) {
                sb.append(this.preKeyDelim);
                sb.append(item.getKey());
                sb.append(this.postKeyDelim);
                sb.append(item.getValue());
                sb.append(this.postValueDelim);
            }
            if (this.trim) {
                sb.setLength(Math.max(0, sb.length() - this.postValueDelim.length()));
            }
            return sb.toString();
        }
    }

    private static class ExceptionOnDuplicateKeyMap<K, V>
    extends QuickMap<K, V> {
        private ExceptionOnDuplicateKeyMap(Map<K, V> delegate) {
            super(delegate);
        }

        @Override
        public V put(K key, V value) {
            V retVal;
            if (this.delegate.containsKey(key)) {
                this.errorMsg(key, value);
            }
            if ((retVal = this.delegate.put(key, value)) != null) {
                this.errorMsg(key, value);
            }
            return retVal;
        }

        private V errorMsg(K key, V value) {
            String msg = "Duplicate key " + key + " found.";
            msg = msg + " new val is " + (value == null ? null : value.getClass()) + "(" + value + ")";
            throw new IllegalArgumentException(msg);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private static class ExceptionOnDuplicateSet<T>
    implements Set<T> {
        private Set<T> delegate;

        private ExceptionOnDuplicateSet(Set<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean add(T t) {
            if (this.delegate.contains(t)) {
                throw new IllegalArgumentException("Duplicate entry attempt. " + t + " already contained");
            }
            return this.delegate.add(t);
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean retVal = false;
            for (T t : c) {
                retVal |= this.add(t);
            }
            return retVal;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.delegate.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.delegate.removeAll(c);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate == o || this.delegate != null && this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate != null ? this.delegate.hashCode() : 0;
        }
    }

    private static class DelimitedCollection<T>
    extends QuickCollection<T> {
        private String delimiter = ",";

        private DelimitedCollection(Collection<T> delegate) {
            this.delegate = delegate;
        }

        private DelimitedCollection(Collection<T> delegate, String delimiter) {
            this.delegate = delegate;
            this.delimiter = delimiter;
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder();
            for (Object t : this.delegate) {
                b.append(t).append(this.delimiter);
            }
            b.setLength(Math.max(0, b.length() - this.delimiter.length()));
            return b.toString();
        }
    }
}

