/*
 * Decompiled with CFR 0.152.
 */
package org.bongiorno.misc.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.Objects;
import org.bongiorno.misc.collections.WSCollections;

public class OtherUtils {
    private static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public static boolean fieldEquals(Object a, Object b) throws IllegalAccessException {
        boolean eq = true;
        Field[] fields = a.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length && eq; ++i) {
            Field field = fields[i];
            int mods = field.getModifiers();
            if (!Modifier.isPrivate(mods) || Modifier.isStatic(mods)) continue;
            field.setAccessible(true);
            Object me = field.get(a);
            Object he = field.get(b);
            field.setAccessible(false);
            eq = me == he || me != null && he != null && me.equals(he);
        }
        return eq;
    }

    public static int fieldHashCode(Object a) throws IllegalAccessException {
        Field[] fields;
        int hash = 1;
        for (Field field : fields = a.getClass().getDeclaredFields()) {
            int mods = field.getModifiers();
            if (!Modifier.isPrivate(mods) || Modifier.isStatic(mods)) continue;
            field.setAccessible(true);
            Object me = field.get(a);
            field.setAccessible(false);
            if (me == null) continue;
            hash *= 31 * me.hashCode() >> 7;
        }
        return hash;
    }

    public static int hashCodeSeries(Object ... cherrios) {
        int hash = 1;
        for (Object field : cherrios) {
            hash *= 31 * field.hashCode() >> 7;
        }
        return hash;
    }

    public static Collection<Field> nullFields(Object o) throws IllegalAccessException {
        Collection<Field> result = WSCollections.delimitedCollection(new LinkedList(), "\n");
        for (Field field : o.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            if (field.get(o) != null) continue;
            result.add(field);
        }
        return result;
    }

    public static String hexFormat(byte[] data) {
        Formatter f = new Formatter();
        for (byte b : data) {
            f.format("%02x", b);
        }
        return f.toString();
    }

    public static boolean zeroOrAllNull(Object ... things) {
        return OtherUtils.zeroOrAllNull(Arrays.asList(things));
    }

    public static boolean zeroOrAllNull(Collection<?> things) {
        boolean result;
        boolean bl = result = things == null;
        if (!result) {
            long count = things.stream().filter(Objects::nonNull).count();
            result = count == 0L || count == (long)things.size();
        }
        return result;
    }

    public static String getMyHostname() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            System.err.println("Unknown *local* host?  Really?");
            e.printStackTrace(System.err);
        }
        return hostName;
    }

    public static boolean isImgPng(byte[] imgData) {
        boolean match = imgData.length >= PNG_SIGNATURE.length;
        for (int i = 0; match && i < PNG_SIGNATURE.length; ++i) {
            match = imgData[i] == PNG_SIGNATURE[i];
        }
        return match;
    }
}

