/*
 * Decompiled with CFR 0.152.
 */
package org.bongiorno.misc.utils;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.util.ReflectionUtils;

public class TypeIgnoringEqualitor<T> {
    private Class<T> type;
    private Set<Class> ignoredTypes;

    public TypeIgnoringEqualitor(Class<T> type, Class ... ignoredTypes) {
        this.type = type;
        this.ignoredTypes = new HashSet<Class>(Arrays.asList(ignoredTypes));
    }

    public TypeIgnoringEqualitor(Class<T> type, Set<Class> ignoredTypes) {
        this.type = type;
        this.ignoredTypes = ignoredTypes;
    }

    public boolean equal(T o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null || o1.getClass() != o2.getClass()) {
            return false;
        }
        FieldMatcher matcher = new FieldMatcher(o1, o2);
        ReflectionUtils.doWithFields(this.type, (ReflectionUtils.FieldCallback)matcher);
        return matcher.paramsEqual();
    }

    public Set<Class> getIgnoredTypes() {
        return this.ignoredTypes;
    }

    private class FieldMatcher
    implements ReflectionUtils.FieldCallback {
        private Object first;
        private Object second;
        Set<Field> mismatches = new HashSet<Field>();

        private FieldMatcher(Object first, Object second) {
            this.first = first;
            this.second = second;
        }

        public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
            if (!TypeIgnoringEqualitor.this.ignoredTypes.contains(field.getType())) {
                field.setAccessible(true);
                Object firstVal = field.get(this.first);
                Object secondVal = field.get(this.second);
                if (!(firstVal == secondVal || firstVal != null && firstVal.equals(secondVal))) {
                    this.mismatches.add(field);
                }
            }
        }

        public boolean paramsEqual() {
            return this.mismatches.isEmpty();
        }
    }
}

