/*
 * Decompiled with CFR 0.152.
 */
package org.bongiorno.misc.validation;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Pattern;
import org.bongiorno.misc.validation.PatternForCollections;

public class MultiStringValidator
implements ConstraintValidator<PatternForCollections, Iterable<String>> {
    private Predicate<String> matchPredicate;

    public void initialize(PatternForCollections annotation) {
        Pattern.Flag[] flags = annotation.flags();
        int intFlags = 0;
        for (Pattern.Flag flag : flags) {
            intFlags |= flag.getValue();
        }
        Pattern pattern = Pattern.compile(annotation.regexp(), intFlags);
        this.matchPredicate = pattern.asPredicate();
    }

    public boolean isValid(Iterable<String> value, ConstraintValidatorContext context) {
        return value == null || StreamSupport.stream(value.spliterator(), false).allMatch(this.matchPredicate);
    }
}

