/*
 * Decompiled with CFR 0.152.
 */
package org.bongiorno.validation.validator.internal;

import java.lang.reflect.InvocationTargetException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ValidationException;
import org.apache.commons.beanutils.PropertyUtils;
import org.bongiorno.validation.constraints.EqualProperties;

public class EqualPropertiesValidator
implements ConstraintValidator<EqualProperties, Object> {
    private String[] properties;
    private boolean violationOnProperty;

    public void initialize(EqualProperties constraint) {
        this.properties = constraint.value();
        if (this.properties == null || this.properties.length < 2) {
            throw new ValidationException("You have to define at least 2 properties");
        }
        this.violationOnProperty = constraint.violationOnProperty();
    }

    public boolean isValid(Object bean, ConstraintValidatorContext context) {
        try {
            if (bean == null) {
                return true;
            }
            if (this.violationOnProperty) {
                context.disableDefaultConstraintViolation();
            }
            boolean valid = true;
            Object original = PropertyUtils.getSimpleProperty((Object)bean, (String)this.properties[0]);
            for (String property : this.properties) {
                Object copy = PropertyUtils.getSimpleProperty((Object)bean, (String)property);
                if (copy == null || copy.equals(original)) continue;
                valid = false;
                if (!this.violationOnProperty) continue;
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode(property).addConstraintViolation();
            }
            return valid;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ValidationException((Throwable)e);
        }
    }
}

