/*
 * Decompiled with CFR 0.152.
 */
package org.bongiorno.validation.validator.internal.banking.bitcoin;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.bongiorno.validation.validator.internal.banking.bitcoin.AddressFormatException;

class Base58 {
    public static final String ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    private static final int[] INDEXES;

    Base58() {
    }

    static boolean isValidChecksum(String address) {
        try {
            Base58.decodeChecked(address);
            return true;
        }
        catch (AddressFormatException e) {
            return false;
        }
    }

    private static byte[] decode(String input) throws AddressFormatException {
        int zeroCount;
        if (input.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            int digit58 = -1;
            if (c >= '\u0000' && c < '\u0080') {
                digit58 = INDEXES[c];
            }
            if (digit58 < 0) {
                throw new AddressFormatException("Illegal character " + c + " at " + i);
            }
            input58[i] = (byte)digit58;
        }
        for (zeroCount = 0; zeroCount < input58.length && input58[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input.length()];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < input58.length) {
            byte mod = Base58.divmod256(input58, startAt);
            if (input58[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = mod;
        }
        while (j < temp.length && temp[j] == 0) {
            ++j;
        }
        return Base58.copyOfRange(temp, j - zeroCount, temp.length);
    }

    private static byte[] decodeChecked(String input) throws AddressFormatException {
        byte[] hash;
        byte[] tmp = Base58.decode(input);
        if (tmp.length < 4) {
            throw new AddressFormatException("Input too short");
        }
        byte[] bytes = Base58.copyOfRange(tmp, 0, tmp.length - 4);
        byte[] checksum = Base58.copyOfRange(tmp, tmp.length - 4, tmp.length);
        if (!Arrays.equals(checksum, hash = Base58.copyOfRange(tmp = Base58.doubleDigest(bytes), 0, 4))) {
            throw new AddressFormatException("Checksum does not validate");
        }
        return bytes;
    }

    private static byte divmod256(byte[] number58, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number58.length; ++i) {
            int digit58 = number58[i] & 0xFF;
            int temp = remainder * 58 + digit58;
            number58[i] = (byte)(temp / 256);
            remainder = temp % 256;
        }
        return (byte)remainder;
    }

    private static byte[] copyOfRange(byte[] source, int from, int to) {
        byte[] range = new byte[to - from];
        System.arraycopy(source, from, range, 0, range.length);
        return range;
    }

    private static byte[] doubleDigest(byte[] input) {
        return Base58.doubleDigest(input, 0, input.length);
    }

    private static byte[] doubleDigest(byte[] input, int offset, int length) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(input, offset, length);
            byte[] first = digest.digest();
            return digest.digest(first);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        int i;
        INDEXES = new int[128];
        for (i = 0; i < INDEXES.length; ++i) {
            Base58.INDEXES[i] = -1;
        }
        for (i = 0; i < ALPHABET.length(); ++i) {
            Base58.INDEXES[ALPHABET.charAt((int)i)] = i;
        }
    }
}

