/*
 * Decompiled with CFR 0.152.
 */
package org.bongiorno.validation.validator.internal.net;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.validator.routines.DomainValidator;
import org.bongiorno.validation.constraints.net.TLD;

public class TLDValidatorForString
implements ConstraintValidator<TLD, String> {
    private Set<TLD.TLDType> types;

    public void initialize(TLD constraint) {
        this.types = new HashSet<TLD.TLDType>(Arrays.asList(constraint.value()));
    }

    public boolean isValid(String tld, ConstraintValidatorContext context) {
        if (tld == null) {
            return true;
        }
        DomainValidator v = DomainValidator.getInstance();
        Predicate<String> p = arg_0 -> ((DomainValidator)v).isValidCountryCodeTld(arg_0);
        p.or(arg_0 -> ((DomainValidator)v).isValidGenericTld(arg_0)).or(arg_0 -> ((DomainValidator)v).isValidInfrastructureTld(arg_0)).or(arg_0 -> ((DomainValidator)v).isValidLocalTld(arg_0));
        if (this.types.contains((Object)TLD.TLDType.COUNTRY) && v.isValidCountryCodeTld(tld)) {
            return true;
        }
        if (this.types.contains((Object)TLD.TLDType.GENERIC) && v.isValidGenericTld(tld)) {
            return true;
        }
        if (this.types.contains((Object)TLD.TLDType.INFRASTRUCTURE) && v.isValidInfrastructureTld(tld)) {
            return true;
        }
        return this.types.contains((Object)TLD.TLDType.LOCAL) && v.isValidLocalTld(tld);
    }
}

