/*
 * Decompiled with CFR 0.152.
 */
package org.bongiorno.validation.validator.jsr349.size;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Size;
import org.springframework.web.multipart.MultipartFile;

public class SizeValidatorForMultipartFile
implements ConstraintValidator<Size, MultipartFile> {
    private long min;
    private long max;

    public void initialize(Size constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
    }

    public boolean isValid(MultipartFile file, ConstraintValidatorContext context) {
        if (file == null || file.isEmpty()) {
            return true;
        }
        long size = file.getSize();
        return this.min <= size && size <= this.max;
    }
}

