/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.bonitasoft.engine.bpm.bar.BarResourceVisitor;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;

public class ExternalResourceContribution
implements BusinessArchiveContribution {
    public static final String EXTERNAL_RESOURCE_FOLDER = "resources";

    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File externalResourceFolder = new File(barFolder, EXTERNAL_RESOURCE_FOLDER);
        if (externalResourceFolder.exists() && !externalResourceFolder.isFile()) {
            BarResourceVisitor barResourceVisitor = new BarResourceVisitor(businessArchive, barFolder.toPath());
            Files.walkFileTree(barFolder.toPath(), barResourceVisitor);
            return barResourceVisitor.getResourcesCount() > 0;
        }
        return false;
    }

    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File externalResourceFolder = new File(barFolder, EXTERNAL_RESOURCE_FOLDER);
        externalResourceFolder.mkdir();
        int beginIndex = EXTERNAL_RESOURCE_FOLDER.length();
        Map<String, byte[]> resources = businessArchive.getResources("^resources/.*$");
        for (Map.Entry<String, byte[]> entry : resources.entrySet()) {
            File fullPathFile = new File(externalResourceFolder, entry.getKey().substring(beginIndex));
            fullPathFile.getParentFile().mkdirs();
            Files.write(fullPathFile.toPath(), entry.getValue(), new OpenOption[0]);
        }
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public String getName() {
        return EXTERNAL_RESOURCE_FOLDER;
    }
}

