/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.bonitasoft.engine.bpm.bar.ActorMappingMarshaller;
import org.bonitasoft.engine.bpm.bar.BarResource;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.InvalidBusinessArchiveFormatException;
import org.bonitasoft.engine.bpm.bar.XmlMarshallException;
import org.bonitasoft.engine.bpm.bar.actorMapping.ActorMapping;
import org.bonitasoft.engine.bpm.bar.form.model.FormMappingModel;
import org.bonitasoft.engine.bpm.document.DocumentDefinition;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;

public class BusinessArchiveBuilder {
    private BusinessArchive entity;

    public static BusinessArchiveBuilder aBusinessArchive() {
        return new BusinessArchiveBuilder().createNewBusinessArchive();
    }

    public BusinessArchiveBuilder createNewBusinessArchive() {
        this.entity = new BusinessArchive();
        return this;
    }

    public BusinessArchiveBuilder setProcessDefinition(DesignProcessDefinition processDefinition) {
        this.entity.setProcessDefinition(processDefinition);
        return this;
    }

    public BusinessArchiveBuilder setParameters(Map<String, String> parameters) {
        this.entity.setParameters(parameters);
        return this;
    }

    public BusinessArchiveBuilder addClasspathResource(BarResource resource) {
        this.addBarResourceInPath(resource, "classpath/");
        return this;
    }

    public BusinessArchiveBuilder addConnectorImplementation(BarResource resource) {
        this.addBarResourceInPath(resource, "connector/");
        return this;
    }

    public BusinessArchiveBuilder addUserFilters(BarResource resource) {
        this.addBarResourceInPath(resource, "userFilters/");
        return this;
    }

    @Deprecated
    public BusinessArchiveBuilder setActorMapping(byte[] xmlContent) throws IOException {
        ActorMapping actorMapping;
        ActorMappingMarshaller marshaller = new ActorMappingMarshaller();
        try {
            actorMapping = marshaller.deserializeFromXML(xmlContent);
        }
        catch (XmlMarshallException e) {
            throw new IOException("Generation of the actorMapping from the provided Xml failed", e);
        }
        this.setActorMapping(actorMapping);
        return this;
    }

    public BusinessArchiveBuilder setFormMappings(FormMappingModel formMappingModel) {
        this.entity.setFormMappings(formMappingModel);
        return this;
    }

    public BusinessArchiveBuilder addExternalResource(BarResource resource) {
        this.addBarResourceInPath(resource, "resources/");
        return this;
    }

    public BusinessArchiveBuilder addDocumentResource(BarResource resource) {
        this.addBarResourceInPath(resource, "documents/");
        return this;
    }

    protected void addBarResourceInPath(BarResource resource, String path) {
        String resourcePath = path + resource.getName();
        byte[] resourceContent = resource.getContent();
        if (resourceContent == null || resourceContent.length == 0) {
            throw new IllegalArgumentException("You are trying to add file " + resourcePath + " with empty content into the BusinessArchive (bar file). Either add content to this file, or remove it from the resources.");
        }
        this.entity.addResource(resourcePath, resourceContent);
    }

    public BusinessArchive done() throws InvalidBusinessArchiveFormatException {
        if (this.entity.getProcessDefinition() == null) {
            throw new InvalidBusinessArchiveFormatException("missing process definition");
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (DocumentDefinition document : this.entity.getProcessDefinition().getFlowElementContainer().getDocumentDefinitions()) {
            byte[] resources;
            if (document.getFile() == null || document.getFile().isEmpty() || (resources = this.entity.getResource("documents/" + document.getFile())) != null) continue;
            errors.add("missing document in the business archive that is present in the process definition " + document.getFile());
        }
        if (!errors.isEmpty()) {
            throw new InvalidBusinessArchiveFormatException(errors);
        }
        return this.entity;
    }

    public ActorMapping getActorMapping() {
        return this.entity.getActorMapping();
    }

    public BusinessArchiveBuilder setActorMapping(ActorMapping actorMapping) {
        this.entity.setActorMapping(actorMapping);
        return this;
    }
}

