/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.bonitasoft.engine.bdm.BDMQueryUtil;
import org.bonitasoft.engine.bdm.FindQueryGenerator;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.FieldType;
import org.bonitasoft.engine.bdm.model.field.RelationField;
import org.bonitasoft.engine.bdm.model.field.SimpleField;
import org.junit.jupiter.api.Test;

class BDMQueryUtilTest {
    private final FindQueryGenerator findQueryGenerator = new FindQueryGenerator();

    BDMQueryUtilTest() {
    }

    @Test
    void createProvidedQueriesForBOShouldNotGenerateGetAllForUniqueConstraint() {
        BusinessObject bo = new BusinessObject();
        bo.setQualifiedName("com.corp.Arrival");
        SimpleField field = new SimpleField();
        field.setName("people");
        field.setType(FieldType.INTEGER);
        bo.addField((Field)field);
        bo.addUniqueConstraint("someName", new String[]{"people"});
        List queries = BDMQueryUtil.createProvidedQueriesForBusinessObject((BusinessObject)bo);
        Assertions.assertThat((List)queries).extracting(Query::getName).isNotEmpty();
        Assertions.assertThat((List)queries).extracting(Query::getName).doesNotContain((Object[])new String[]{"getAllArrivalByPeople"});
    }

    @Test
    void createProvidedQueriesForBOWithOneUniqueAndOneNonUniqueFieldShouldGenerate3Queries() {
        BusinessObject bo = new BusinessObject();
        bo.setQualifiedName("com.corp.Arrival");
        bo.addField((Field)this.aStringField("unikAttr"));
        bo.addField((Field)this.aStringField("unconstrainedAttr"));
        bo.addUniqueConstraint("someConstraintName", new String[]{"unikAttr"});
        List queries = BDMQueryUtil.createProvidedQueriesForBusinessObject((BusinessObject)bo);
        Assertions.assertThat((List)queries).extracting(Query::getName).containsOnly((Object[])new String[]{"find", "countForFind", "findByPersistenceId", "findByUnikAttr", "findByUnconstrainedAttr", "countForFindByUnconstrainedAttr"});
    }

    @Test
    void createProvidedQueriesForShouldNotGenerateAQueryForRelationField() {
        BusinessObject bo = new BusinessObject();
        bo.setQualifiedName("com.corp.Arrival");
        bo.addField((Field)this.aStringField("unikAttr"));
        bo.addField((Field)this.aRelationField("employee"));
        List queries = BDMQueryUtil.createProvidedQueriesForBusinessObject((BusinessObject)bo);
        Assertions.assertThat((List)queries).extracting(Query::getName).containsOnly((Object[])new String[]{"find", "countForFind", "findByPersistenceId", "findByUnikAttr", "countForFindByUnikAttr"});
    }

    protected SimpleField aStringField(String name) {
        SimpleField field = new SimpleField();
        field.setName(name);
        field.setType(FieldType.STRING);
        return field;
    }

    protected RelationField aRelationField(String name) {
        RelationField field = new RelationField();
        field.setName(name);
        field.setType(RelationField.Type.COMPOSITION);
        field.setReference(null);
        return field;
    }

    @Test
    void should_createSelectAllQueryreturn_query_without_parameters() {
        BusinessObject bo = new BusinessObject();
        bo.setQualifiedName("org.bonita.Employee");
        SimpleField field = new SimpleField();
        field.setName("name");
        field.setType(FieldType.STRING);
        bo.addField((Field)field);
        Query query = this.findQueryGenerator.createSelectAllQueryForBusinessObject(bo);
        Assertions.assertThat((Object)query).isNotNull();
        Assertions.assertThat((String)query.getContent()).contains(new CharSequence[]{"SELECT e\nFROM Employee e"});
        Assertions.assertThat((String)query.getContent()).doesNotContain(new CharSequence[]{"WHERE"});
        Assertions.assertThat((String)query.getName()).isEqualTo("find");
        Assertions.assertThat((String)query.getReturnType()).isEqualTo(List.class.getName());
        Assertions.assertThat((List)query.getQueryParameters()).isEmpty();
    }

    @Test
    void should_getAllProvidedQueriesNameForBusinessObject_not_return_query_for_RelationFields() {
        BusinessObject bo = new BusinessObject();
        bo.setQualifiedName("org.bonita.Employee");
        SimpleField field = new SimpleField();
        field.setName("name");
        field.setType(FieldType.STRING);
        bo.addField((Field)field);
        RelationField f2 = new RelationField();
        f2.setName("name2");
        f2.setType(RelationField.Type.COMPOSITION);
        f2.setReference(bo);
        bo.addField((Field)f2);
        Assertions.assertThat((Collection)BDMQueryUtil.getAllProvidedQueriesNameForBusinessObject((BusinessObject)bo)).doesNotContain((Object[])new String[]{"findByName2"});
    }

    @Test
    void should_generate_findByPersistenceId_query_in_provided_queries_names() {
        BusinessObject bo = new BusinessObject();
        bo.setQualifiedName("org.bonita.Employee");
        SimpleField field = new SimpleField();
        field.setName("name");
        field.setType(FieldType.STRING);
        bo.addField((Field)field);
        Assertions.assertThat((Collection)BDMQueryUtil.getAllProvidedQueriesNameForBusinessObject((BusinessObject)bo)).contains((Object[])new String[]{"findByPersistenceId"});
    }

    @Test
    void should_generate_findByPersistenceId_query_in_provided_queries() {
        BusinessObject bo = new BusinessObject();
        bo.setQualifiedName("org.bonita.Employee");
        Assertions.assertThat((List)BDMQueryUtil.createProvidedQueriesForBusinessObject((BusinessObject)bo)).extracting(new String[]{"name", "content", "returnType"}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"findByPersistenceId", "SELECT e\nFROM Employee e\nWHERE e.persistenceId= :persistenceId\n", "org.bonita.Employee"})});
    }

    @Test
    void should_not_generate_findByPersistenceId_query_in_provided_queries_names_if_already_defined_in_custom_queries() {
        BusinessObject bo = new BusinessObject();
        bo.setQualifiedName("org.bonita.Employee");
        SimpleField field = new SimpleField();
        field.setName("name");
        field.setType(FieldType.STRING);
        bo.addField((Field)field);
        bo.getQueries().add(new Query("findByPersistenceId", "", ""));
        Assertions.assertThat((Collection)BDMQueryUtil.getAllProvidedQueriesNameForBusinessObject((BusinessObject)bo)).doesNotContain((Object[])new String[]{"findByPersistenceId"});
    }

    @Test
    void should_return_related_count_query_name() {
        Assertions.assertThat((String)BDMQueryUtil.getCountQueryName((String)"find")).isEqualTo("countForFind");
        Assertions.assertThat((String)BDMQueryUtil.getCountQueryName((String)"findByStreet")).isEqualTo("countForFindByStreet");
        Assertions.assertThat((String)BDMQueryUtil.getCountQueryName((String)"myQuery")).isEqualTo("countForMyQuery");
    }
}

