/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm;

import org.assertj.core.api.Assertions;
import org.bonitasoft.engine.bdm.BDMSimpleNameProvider;
import org.junit.jupiter.api.Test;

class BDMSimpleNameProviderTest {
    BDMSimpleNameProviderTest() {
    }

    @Test
    void getSimpleNameAlias_should_return_the_first_char_in_lower_case() {
        Assertions.assertThat((char)BDMSimpleNameProvider.getSimpleNameAlias((String)"employee")).isEqualTo('e');
        Assertions.assertThat((char)BDMSimpleNameProvider.getSimpleNameAlias((String)"Car")).isEqualTo('c');
    }

    @Test
    void getSimpleBusinessObjectName_should_ignore_package_name() {
        String businessObjectQualifiedName = "com.company.Employee";
        String simpleName = BDMSimpleNameProvider.getSimpleBusinessObjectName((String)businessObjectQualifiedName);
        Assertions.assertThat((String)simpleName).isEqualTo("Employee");
    }

    @Test
    void getSimpleBusinessObjectName_should_return_the_entire_name_when_package_name_is_absent() {
        String businessObjectQualifiedName = "Employee";
        String simpleName = BDMSimpleNameProvider.getSimpleBusinessObjectName((String)businessObjectQualifiedName);
        Assertions.assertThat((String)simpleName).isEqualTo("Employee");
    }
}

