/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBException;
import org.assertj.core.api.Assertions;
import org.bonitasoft.engine.bdm.BusinessObjectModelConverter;
import org.bonitasoft.engine.bdm.builder.BusinessObjectModelBuilder;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.junit.jupiter.api.Test;

class BusinessObjectModelConverterTest {
    private final BusinessObjectModelConverter convertor = new BusinessObjectModelConverter();

    BusinessObjectModelConverterTest() {
    }

    @Test
    void zipThenUnzipBOMShouldReturnTheOriginalBOM() throws Exception {
        BusinessObjectModel bom = new BusinessObjectModelBuilder().buildDefaultBOM();
        byte[] zip = this.convertor.zip(bom);
        BusinessObjectModel actual = this.convertor.unzip(zip);
        Assertions.assertThat((Object)actual).isEqualTo((Object)bom);
    }

    @Test
    void zipThenUnzipBOMShouldReturnTheOriginalBOMWithUniqueConstraint() throws Exception {
        BusinessObjectModel bom = new BusinessObjectModelBuilder().buildBOMWithUniqueConstraint();
        byte[] zip = this.convertor.zip(bom);
        BusinessObjectModel actual = this.convertor.unzip(zip);
        Assertions.assertThat((Object)actual).isEqualTo((Object)bom);
    }

    @Test
    void zipThenUnzipBOMShouldReturnTheOriginalBOMWithQuery() throws Exception {
        BusinessObjectModel bom = new BusinessObjectModelBuilder().buildBOMWithQuery();
        byte[] zip = this.convertor.zip(bom);
        BusinessObjectModel actual = this.convertor.unzip(zip);
        Assertions.assertThat((Object)actual).isEqualTo((Object)bom);
    }

    @Test
    void zipAnBOMWithAnEmptyShouldThrowAnException() {
        BusinessObjectModel bom = new BusinessObjectModelBuilder().buildBOMWithAnEmptyEntity();
        Assertions.assertThatExceptionOfType(JAXBException.class).isThrownBy(() -> this.convertor.zip(bom));
    }

    @Test
    void zipAnBOMWithAnEmptyFieldShouldThrowAnException() {
        BusinessObjectModel bom = new BusinessObjectModelBuilder().buildBOMWithAnEmptyField();
        Assertions.assertThatExceptionOfType(JAXBException.class).isThrownBy(() -> this.convertor.zip(bom));
    }

    @Test
    void unzipADifferentZipThrowAnException() throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(stream);){
            zos.putNextEntry(new ZipEntry("bonita"));
            zos.write("bpm".getBytes());
        }
        byte[] zip = stream.toByteArray();
        Assertions.assertThatExceptionOfType(IOException.class).isThrownBy(() -> this.convertor.unzip(zip)).withMessage("the file bom.xml is missing in the zip");
    }

    @Test
    void should_be_backward_compatible() throws Exception {
        try (InputStream resource = BusinessObjectModelConverterTest.class.getResourceAsStream("/bom_6.3.0.xml");){
            Assertions.assertThat((InputStream)resource).isNotNull();
            byte[] xml = resource.readAllBytes();
            BusinessObjectModel bom = this.convertor.unmarshall(xml);
            Assertions.assertThat((String)bom.getModelVersion()).isNullOrEmpty();
            Assertions.assertThat((String)bom.getProductVersion()).isNullOrEmpty();
        }
    }

    @Test
    void should_unmarshall_bom_with_namespace() throws Exception {
        try (InputStream resource = BusinessObjectModelConverterTest.class.getResourceAsStream("/bom_7.11.0.xml");){
            Assertions.assertThat((InputStream)resource).isNotNull();
            byte[] xml = resource.readAllBytes();
            BusinessObjectModel bom = this.convertor.unmarshall(xml);
            Assertions.assertThat((String)bom.getModelVersion()).isEqualTo("1.0");
            Assertions.assertThat((String)bom.getProductVersion()).isEqualTo("7.11.0");
        }
    }

    @Test
    void should_add_namespace_when_missing() throws Exception {
        try (InputStream resource = BusinessObjectModelConverterTest.class.getResourceAsStream("/bom_6.3.0.xml");){
            Assertions.assertThat((InputStream)resource).isNotNull();
            byte[] xml = resource.readAllBytes();
            String str = new String(xml);
            Assertions.assertThat((String)str).doesNotContain(new CharSequence[]{"xmlns=\"http://documentation.bonitasoft.com/bdm-xml-schema/1.0\""});
            BusinessObjectModel bom = this.convertor.unmarshall(xml);
            xml = this.convertor.marshall(bom);
            str = new String(xml);
            Assertions.assertThat((String)str).contains(new CharSequence[]{"xmlns=\"http://documentation.bonitasoft.com/bdm-xml-schema/1.0\""});
        }
    }

    @Test
    void should_be_backward_compatible_with_version() throws Exception {
        try (InputStream resource = BusinessObjectModelConverterTest.class.getResourceAsStream("/bom_7.2.0.xml");){
            Assertions.assertThat((InputStream)resource).isNotNull();
            byte[] xml = resource.readAllBytes();
            BusinessObjectModel bom = this.convertor.unmarshall(xml);
            Assertions.assertThat((String)bom.getModelVersion()).isEqualTo("1.0");
            Assertions.assertThat((String)bom.getProductVersion()).isEqualTo("7.2.0");
            BusinessObjectModel unmarshallBom = this.convertor.unmarshall(this.convertor.marshall(bom));
            Assertions.assertThat((String)unmarshallBom.getModelVersion()).isEqualTo("1.0");
            Assertions.assertThat((String)unmarshallBom.getProductVersion()).isEqualTo("7.2.0");
        }
    }

    @Test
    void should_set_current_model_version_when_marshalling() throws Exception {
        BusinessObjectModel bom = new BusinessObjectModelBuilder().buildBOMWithQuery();
        Assertions.assertThat((String)bom.getModelVersion()).isNullOrEmpty();
        Assertions.assertThat((String)bom.getProductVersion()).isNullOrEmpty();
        BusinessObjectModel unmarshalledBom = this.convertor.unmarshall(this.convertor.marshall(bom));
        Assertions.assertThat((String)unmarshalledBom.getModelVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)bom.getProductVersion()).isNull();
    }

    @Test
    void zipThenUnzipBOMShouldReturnTheOriginalBOMWithIndex() throws Exception {
        BusinessObjectModel bom = new BusinessObjectModelBuilder().buildBOMWithIndex();
        byte[] zip = this.convertor.zip(bom);
        BusinessObjectModel actual = this.convertor.unzip(zip);
        Assertions.assertThat((Object)actual).isEqualTo((Object)bom);
    }

    @Test
    void marshall_and_unmarshall_should_return_the_same_object() throws Exception {
        BusinessObjectModel expected = new BusinessObjectModelBuilder().buildDefaultBOM();
        byte[] xml = this.convertor.marshallObjectToXML(expected);
        BusinessObjectModel actual = this.convertor.unmarshallXMLtoObject(xml);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    void marshall_a_null_object_returns_empty() throws Exception {
        byte[] xml = this.convertor.marshallObjectToXML(null);
        Assertions.assertThat((byte[])xml).isEmpty();
    }

    @Test
    void marshall_an_empty_object_throws_a_JAXBException() {
        Assertions.assertThatExceptionOfType(JAXBException.class).isThrownBy(() -> this.convertor.marshallObjectToXML(new BusinessObjectModel()));
    }

    @Test
    void unmarshall_a_null_object_returns_null() throws Exception {
        BusinessObjectModel object = this.convertor.unmarshallXMLtoObject(null);
        Assertions.assertThat((Object)object).isNull();
    }

    @Test
    void unmarshall_an_empty_object_throws_a_JAXBException() {
        Assertions.assertThatExceptionOfType(JAXBException.class).isThrownBy(() -> this.convertor.unmarshallXMLtoObject(new byte[0]));
    }
}

