/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.Index;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.FieldType;
import org.bonitasoft.engine.bdm.model.field.SimpleField;
import org.junit.jupiter.api.Test;

class BusinessObjectTest {
    BusinessObjectTest() {
    }

    @Test
    void setQualifiedNameShouldWorkIfAValidQualifiedName() {
        Assertions.assertThat((String)new BusinessObject("com.Employee").getSimpleName()).isEqualTo("Employee");
    }

    @Test
    void setQualifiedNameShouldWorkIfAValidQualifiedNameInLowercase() {
        Assertions.assertThat((String)new BusinessObject("com.employee").getSimpleName()).isEqualTo("employee");
    }

    @Test
    void setQualifiedNameShouldWorkWithoutPackageName() {
        Assertions.assertThat((String)new BusinessObject("Employee").getSimpleName()).isEqualTo("Employee");
    }

    @Test
    void addUniqueConstraintShouldWorkIfTheFieldExists() {
        SimpleField field = new SimpleField();
        field.setName("field");
        field.setType(FieldType.STRING);
        BusinessObject object = new BusinessObject();
        object.addField((Field)field);
        object.addUniqueConstraint("unique", new String[]{"field"});
        UniqueConstraint expected = new UniqueConstraint();
        expected.setName("unique");
        expected.setFieldNames(List.of("field"));
        Assertions.assertThat((List)object.getUniqueConstraints()).containsExactly((Object[])new UniqueConstraint[]{expected});
    }

    @Test
    void should_addQuery() {
        BusinessObject businessObject = new BusinessObject();
        Query query = businessObject.addQuery("userByName", "SELECT u FROM User u WHERE u.name='romain'", List.class.getName());
        Assertions.assertThat((List)businessObject.getQueries()).containsExactly((Object[])new Query[]{query});
    }

    @Test
    void addIndexShouldWorkIfTheFieldExists() {
        SimpleField field = new SimpleField();
        field.setName("field");
        field.setType(FieldType.STRING);
        Index expected = new Index();
        expected.setName("unique");
        expected.setFieldNames(List.of("field"));
        BusinessObject object = new BusinessObject();
        object.addField((Field)field);
        Index index = object.addIndex("unique", new String[]{"field"});
        Assertions.assertThat((Object)index).isEqualTo((Object)expected);
    }

    @Test
    void addIndexShouldThrowAnExceptionIfNoFieldIsSet() {
        BusinessObject object = new BusinessObject();
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> object.addIndex("unique", (String[])null));
    }

    @Test
    void addIndexShouldThrowAnExceptionIfTheListOfFieldsIsEmpty() {
        BusinessObject object = new BusinessObject();
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> object.addIndex("unique", new String[0]));
    }
}

