/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.engine.bdm.FindQueryGenerator;
import org.bonitasoft.engine.bdm.builder.BusinessObjectBuilder;
import org.bonitasoft.engine.bdm.builder.FieldBuilder;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.model.assertion.QueryAssert;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.FieldType;
import org.bonitasoft.engine.bdm.model.field.RelationField;
import org.bonitasoft.engine.bdm.model.field.SimpleField;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FindQueryGeneratorTest {
    private FindQueryGenerator queryGenerator;

    FindQueryGeneratorTest() {
    }

    @BeforeEach
    void before() {
        this.queryGenerator = new FindQueryGenerator();
    }

    @Test
    void should_generate_query_name() {
        Assertions.assertThat((String)this.queryGenerator.getQueryName(new String[0])).isEqualTo("find");
        Assertions.assertThat((String)this.queryGenerator.getQueryName(new String[]{"persistenceId"})).isEqualTo("findByPersistenceId");
        Assertions.assertThat((String)this.queryGenerator.getQueryName(new String[]{"lastName", "firstName"})).isEqualTo("findByLastNameAndFirstName");
    }

    @Test
    void should_createQueryNameForUniqueConstraint_throwException_when_null_value() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.queryGenerator.createQueryNameForUniqueConstraint(null));
    }

    @Test
    void should_createCountQueryNameForUniqueConstraint_return_queryname() {
        UniqueConstraint uniqueConstraint = new UniqueConstraint();
        uniqueConstraint.setFieldNames(List.of("name"));
        String countQueryNameForUniqueConstraint = this.queryGenerator.createQueryNameForUniqueConstraint(uniqueConstraint);
        Assertions.assertThat((String)countQueryNameForUniqueConstraint).isEqualTo("findByName");
    }

    @Test
    void should_create_query_for_field() {
        BusinessObject bo = new BusinessObject();
        bo.setQualifiedName("org.bonita.Employee");
        SimpleField field = new SimpleField();
        field.setName("name");
        field.setType(FieldType.STRING);
        bo.addField((Field)field);
        Query query = this.queryGenerator.createQueryForField(bo, (Field)field);
        QueryAssert.assertThat(query).hasName("findByName").hasContent("SELECT e\nFROM Employee e\nWHERE e.name= :name\nORDER BY e.persistenceId").hasReturnType(List.class.getName());
        Assertions.assertThat((List)query.getQueryParameters()).hasSize(1);
    }

    @Test
    void should_create_query_for_unique_constraint() {
        BusinessObject bo = new BusinessObject();
        bo.setQualifiedName("org.bonita.Employee");
        SimpleField field = new SimpleField();
        field.setName("name");
        field.setType(FieldType.STRING);
        bo.addField((Field)field);
        UniqueConstraint uniqueConstraint = new UniqueConstraint();
        uniqueConstraint.setFieldNames(List.of("name"));
        Query query = this.queryGenerator.createQueryForUniqueConstraint(bo, uniqueConstraint);
        QueryAssert.assertThat(query).hasName("findByName").hasContent("SELECT e\nFROM Employee e\nWHERE e.name= :name\n").hasReturnType(bo.getQualifiedName());
        Assertions.assertThat((List)query.getQueryParameters()).hasSize(1);
    }

    @Test
    void should_generate_query_for_lazy_field() {
        BusinessObject employeeBo = BusinessObjectBuilder.aBO("com.company.model.Employee").build();
        BusinessObject addressBo = BusinessObjectBuilder.aBO("com.company.model.Address").build();
        RelationField multipleRelation = FieldBuilder.aRelationField().withName("addresses").ofType(RelationField.Type.AGGREGATION).lazy().referencing(addressBo).multiple().build();
        RelationField singleRelation = FieldBuilder.aRelationField().withName("address").ofType(RelationField.Type.AGGREGATION).lazy().referencing(addressBo).build();
        Query queryForMultipleLazyField = this.queryGenerator.createQueryForLazyField(employeeBo, multipleRelation);
        Query queryForSingleLazyField = this.queryGenerator.createQueryForLazyField(employeeBo, singleRelation);
        QueryAssert.assertThat(queryForMultipleLazyField).hasName("findAddressesByEmployeePersistenceId").hasReturnType(List.class.getName()).hasContent("SELECT addresses_1 FROM Employee employee_0 JOIN employee_0.addresses as addresses_1 WHERE employee_0.persistenceId= :persistenceId");
        QueryAssert.assertThat(queryForSingleLazyField).hasName("findAddressByEmployeePersistenceId").hasReturnType("com.company.model.Address").hasContent("SELECT address_1 FROM Employee employee_0 JOIN employee_0.address as address_1 WHERE employee_0.persistenceId= :persistenceId");
    }
}

