/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.builder;

import org.bonitasoft.engine.bdm.builder.FieldBuilder;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.Index;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.QueryParameter;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.model.field.Field;

public class BusinessObjectBuilder {
    public static final String EMPLOYEE_QUALIFIED_CLASS_NAME = "com.company.model.Employee";
    public static final String ADDRESS_QUALIFIED_CLASS_NAME = "com.company.model.Address";
    private BusinessObject businessObject = new BusinessObject();

    public BusinessObjectBuilder(String qualifiedName) {
        this.businessObject.setQualifiedName(qualifiedName);
    }

    public static BusinessObjectBuilder aBO(String qualifiedName) {
        return new BusinessObjectBuilder(qualifiedName);
    }

    public BusinessObject build() {
        return this.businessObject;
    }

    public BusinessObjectBuilder withField(Field field) {
        this.businessObject.addField(field);
        return this;
    }

    public BusinessObjectBuilder withField(FieldBuilder fieldBuilder) {
        this.businessObject.addField(fieldBuilder.build());
        return this;
    }

    public BusinessObjectBuilder withUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.businessObject.addUniqueConstraint(uniqueConstraint);
        return this;
    }

    public BusinessObjectBuilder withIndex(Index index) {
        this.businessObject.addIndex(index);
        return this;
    }

    public BusinessObjectBuilder withDescription(String description) {
        this.businessObject.setDescription(description);
        return this;
    }

    public BusinessObjectBuilder withQuery(Query query) {
        Query addQuery = this.businessObject.addQuery(query.getName(), query.getContent(), query.getReturnType());
        for (QueryParameter qP : query.getQueryParameters()) {
            addQuery.addQueryParameter(qP.getName(), qP.getClassName());
        }
        return this;
    }
}

