/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.builder;

import java.util.List;
import org.bonitasoft.engine.bdm.builder.BusinessObjectBuilder;
import org.bonitasoft.engine.bdm.builder.FieldBuilder;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.SimpleField;

public class BusinessObjectModelBuilder {
    private final BusinessObjectModel businessObjectModel = new BusinessObjectModel();

    public static BusinessObjectModelBuilder aBOM() {
        return new BusinessObjectModelBuilder();
    }

    public BusinessObjectModelBuilder withBO(BusinessObject bo) {
        this.businessObjectModel.addBusinessObject(bo);
        return this;
    }

    public BusinessObjectModelBuilder withBO(BusinessObjectBuilder boBuilder) {
        this.businessObjectModel.addBusinessObject(boBuilder.build());
        return this;
    }

    public BusinessObjectModelBuilder withBOs(BusinessObject ... bos) {
        for (BusinessObject bo : bos) {
            this.businessObjectModel.addBusinessObject(bo);
        }
        return this;
    }

    public BusinessObjectModel build() {
        return this.businessObjectModel;
    }

    private BusinessObject buildMyBusinessObject() {
        return BusinessObjectBuilder.aBO("BusinessObject").withField(FieldBuilder.aStringField("stringField").nullable().build()).withField(FieldBuilder.aBooleanField("booleanField")).withField(FieldBuilder.aDateField("dateField").notNullable().build()).withField(FieldBuilder.aDoubleField("doubleField").build()).withField(FieldBuilder.anIntegerField("integerField").build()).withField(FieldBuilder.aTextField("textField").build()).build();
    }

    public BusinessObjectModel buildDefaultBOM() {
        BusinessObjectModel bom = new BusinessObjectModel();
        bom.addBusinessObject(this.buildMyBusinessObject());
        return bom;
    }

    public BusinessObjectModel buildBOMWithAnEmptyEntity() {
        BusinessObjectModel bom = new BusinessObjectModel();
        bom.addBusinessObject(new BusinessObject());
        return bom;
    }

    public BusinessObjectModel buildBOMWithAnEmptyField() {
        BusinessObjectModel bom = new BusinessObjectModel();
        BusinessObject businessObject = new BusinessObject();
        businessObject.setQualifiedName("BusinessObject");
        businessObject.addField((Field)new SimpleField());
        bom.addBusinessObject(businessObject);
        return bom;
    }

    public BusinessObjectModel buildBOMWithUniqueConstraint() {
        BusinessObjectModel bom = new BusinessObjectModel();
        BusinessObject employee = this.buildMyBusinessObject();
        employee.addUniqueConstraint("UC_string_double", new String[]{"stringField", "doubleField"});
        bom.addBusinessObject(employee);
        return bom;
    }

    public BusinessObjectModel buildBOMWithQuery() {
        BusinessObjectModel bom = new BusinessObjectModel();
        BusinessObject employee = this.buildMyBusinessObject();
        employee.addQuery("employeeByName", "Select e FROM Employee e WHERE e.name='romain'", List.class.getName());
        bom.addBusinessObject(employee);
        return bom;
    }

    public BusinessObjectModel buildBOMWithIndex() {
        BusinessObjectModel bom = new BusinessObjectModel();
        BusinessObject employee = this.buildMyBusinessObject();
        employee.addIndex("idx_45", new String[]{"stringField", "doubleField"});
        bom.addBusinessObject(employee);
        return bom;
    }
}

