/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.builder;

import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.FieldType;
import org.bonitasoft.engine.bdm.model.field.RelationField;
import org.bonitasoft.engine.bdm.model.field.SimpleField;

public abstract class FieldBuilder {
    protected final Field field;

    private FieldBuilder(Field field) {
        this.field = field;
    }

    public static Field aBooleanField(String name) {
        return FieldBuilder.aSimpleField().withName(name).ofType(FieldType.BOOLEAN).build();
    }

    public static SimpleFieldBuilder aStringField(String name) {
        return FieldBuilder.aSimpleField().withName(name).ofType(FieldType.STRING);
    }

    public static SimpleFieldBuilder aDateField(String name) {
        return FieldBuilder.aSimpleField().withName(name).ofType(FieldType.DATE);
    }

    public static SimpleFieldBuilder aDoubleField(String name) {
        return FieldBuilder.aSimpleField().withName(name).ofType(FieldType.DOUBLE);
    }

    public static SimpleFieldBuilder anIntegerField(String name) {
        return FieldBuilder.aSimpleField().withName(name).ofType(FieldType.INTEGER);
    }

    public static SimpleFieldBuilder aTextField(String name) {
        return FieldBuilder.aSimpleField().withName(name).ofType(FieldType.TEXT);
    }

    public static SimpleFieldBuilder aSimpleField() {
        return new SimpleFieldBuilder();
    }

    public static RelationFieldBuilder aRelationField() {
        return new RelationFieldBuilder();
    }

    public static Field anAggregationField(String name, BusinessObject reference) {
        RelationField relationField = FieldBuilder.aRelationField(name, reference);
        relationField.setType(RelationField.Type.AGGREGATION);
        return relationField;
    }

    public static Field aCompositionField(String name, BusinessObject reference) {
        RelationField relationField = FieldBuilder.aRelationField(name, reference);
        relationField.setType(RelationField.Type.COMPOSITION);
        return relationField;
    }

    private static RelationField aRelationField(String name, BusinessObject reference) {
        RelationField relationField = new RelationField();
        relationField.setName(name);
        relationField.setReference(reference);
        return relationField;
    }

    public FieldBuilder withName(String name) {
        this.field.setName(name);
        return this;
    }

    public FieldBuilder nullable() {
        this.field.setNullable(Boolean.valueOf(true));
        return this;
    }

    public FieldBuilder notNullable() {
        this.field.setNullable(Boolean.valueOf(false));
        return this;
    }

    public FieldBuilder multiple() {
        this.field.setCollection(Boolean.valueOf(true));
        return this;
    }

    public FieldBuilder multiple(boolean collection) {
        this.field.setCollection(Boolean.valueOf(collection));
        return this;
    }

    public Field build() {
        return this.field;
    }

    public static class SimpleFieldBuilder
    extends FieldBuilder {
        public SimpleFieldBuilder() {
            super((Field)new SimpleField());
        }

        public SimpleFieldBuilder ofType(FieldType type) {
            ((SimpleField)this.field).setType(type);
            return this;
        }

        @Override
        public SimpleFieldBuilder withName(String name) {
            return (SimpleFieldBuilder)super.withName(name);
        }

        @Override
        public SimpleFieldBuilder nullable() {
            return (SimpleFieldBuilder)super.nullable();
        }

        @Override
        public SimpleFieldBuilder notNullable() {
            return (SimpleFieldBuilder)super.notNullable();
        }

        public FieldBuilder withLength(int length) {
            ((SimpleField)this.field).setLength(Integer.valueOf(length));
            return this;
        }
    }

    public static class RelationFieldBuilder
    extends FieldBuilder {
        public RelationFieldBuilder() {
            super((Field)new RelationField());
        }

        public RelationFieldBuilder ofType(RelationField.Type type) {
            ((RelationField)this.field).setType(type);
            return this;
        }

        public RelationFieldBuilder composition() {
            ((RelationField)this.field).setType(RelationField.Type.COMPOSITION);
            return this;
        }

        public RelationFieldBuilder aggregation() {
            ((RelationField)this.field).setType(RelationField.Type.AGGREGATION);
            return this;
        }

        public RelationFieldBuilder lazy() {
            ((RelationField)this.field).setFetchType(RelationField.FetchType.LAZY);
            return this;
        }

        public RelationFieldBuilder fetchType(RelationField.FetchType fetchType) {
            ((RelationField)this.field).setFetchType(fetchType);
            return this;
        }

        @Override
        public RelationFieldBuilder withName(String name) {
            return (RelationFieldBuilder)super.withName(name);
        }

        @Override
        public RelationFieldBuilder multiple() {
            return (RelationFieldBuilder)super.multiple();
        }

        @Override
        public RelationFieldBuilder multiple(boolean collection) {
            return (RelationFieldBuilder)super.multiple(collection);
        }

        public RelationFieldBuilder referencing(BusinessObject bo) {
            ((RelationField)this.field).setReference(bo);
            return this;
        }

        public RelationField build() {
            return (RelationField)super.build();
        }
    }
}

