/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.model;

import java.util.Collection;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.bonitasoft.engine.bdm.builder.BusinessObjectBuilder;
import org.bonitasoft.engine.bdm.builder.BusinessObjectModelBuilder;
import org.bonitasoft.engine.bdm.builder.FieldBuilder;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.bdm.model.assertion.BusinessObjectModelAssert;
import org.junit.jupiter.api.Test;

class BusinessObjectModelTest {
    BusinessObjectModelTest() {
    }

    @Test
    void cannot_be_marshalled_when_it_has_no_business_object() {
        BusinessObjectModel businessObjectModel = new BusinessObjectModel();
        BusinessObjectModelAssert.assertThat(businessObjectModel).cannotBeMarshalled();
    }

    @Test
    void can_be_marshalled_when_it_has_at_least_one_business_object() {
        BusinessObjectModel businessObjectModel = new BusinessObjectModel();
        businessObjectModel.addBusinessObject(BusinessObjectBuilder.aBO("aBo").withField(FieldBuilder.aStringField("aField").build()).build());
        BusinessObjectModelAssert.assertThat(businessObjectModel).canBeMarshalled();
    }

    @Test
    void should_have_already_declared_business_object_in_relation_fields() {
        BusinessObject notInModelBO = BusinessObjectBuilder.aBO("notInModelBo").withField(FieldBuilder.aStringField("aField").build()).build();
        BusinessObjectModel businessObjectModel = new BusinessObjectModel();
        businessObjectModel.addBusinessObject(BusinessObjectBuilder.aBO("aBo").withField(FieldBuilder.anAggregationField("aggreg", notInModelBO)).build());
        BusinessObjectModelAssert.assertThat(businessObjectModel).cannotBeMarshalled();
        businessObjectModel.addBusinessObject(notInModelBO);
        BusinessObjectModelAssert.assertThat(businessObjectModel).canBeMarshalled();
    }

    @Test
    void should_list_distincts_business_object_class_names() {
        String aClassName = "aClassName";
        String anotherClassName = "anotherClassName";
        BusinessObjectModel bom = BusinessObjectModelBuilder.aBOM().withBOs(BusinessObjectBuilder.aBO("aClassName").build(), BusinessObjectBuilder.aBO("aClassName").build(), BusinessObjectBuilder.aBO("anotherClassName").build()).build();
        Set classNames = bom.getBusinessObjectsClassNames();
        Assertions.assertThat((Collection)classNames).containsOnlyOnce((Object[])new String[]{"aClassName", "anotherClassName"});
    }
}

