/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.model;

import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.bonitasoft.engine.bdm.builder.BusinessObjectBuilder;
import org.bonitasoft.engine.bdm.builder.FieldBuilder;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.model.assertion.BusinessObjectAssert;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.RelationField;
import org.junit.jupiter.api.Test;

class BusinessObjectTest {
    BusinessObjectTest() {
    }

    @Test
    void should_have_a_qualifiedName_and_at_least_one_field() {
        BusinessObject businessObject = new BusinessObject();
        businessObject.setQualifiedName("aQualifiedName");
        BusinessObjectAssert.assertThat(businessObject).cannotBeMarshalled();
        businessObject = new BusinessObject();
        businessObject.addField(FieldBuilder.aBooleanField("aField"));
        BusinessObjectAssert.assertThat(businessObject).cannotBeMarshalled();
        businessObject = new BusinessObject();
        businessObject.setQualifiedName("aQualifiedName");
        businessObject.addField(FieldBuilder.aBooleanField("aField"));
        BusinessObjectAssert.assertThat(businessObject).canBeMarshalled();
    }

    @Test
    void could_have_simpleFields_and_relationFields() {
        BusinessObject businessObject = new BusinessObject();
        businessObject.setQualifiedName("aQualifiedName");
        businessObject.addField(FieldBuilder.aBooleanField("aSimpleField"));
        businessObject.addField(FieldBuilder.anAggregationField("aggregationField", BusinessObjectBuilder.aBO("boName").withField(FieldBuilder.aBooleanField("aField")).build()));
        BusinessObjectAssert.assertThat(businessObject).canBeMarshalled();
    }

    @Test
    void could_have_relationFields_referencing_itself() {
        BusinessObject bo = BusinessObjectBuilder.aBO("aBo").build();
        bo.addField(FieldBuilder.anAggregationField("itselfRef", bo));
        BusinessObjectAssert.assertThat(bo).canBeMarshalled();
    }

    @Test
    void could_have_optional_uniqueConstraints() {
        BusinessObject bo = BusinessObjectBuilder.aBO("aBo").withField(FieldBuilder.aBooleanField("field1")).withField(FieldBuilder.aBooleanField("field2")).build();
        bo.addUniqueConstraint("const", new String[]{"field1"});
        bo.addUniqueConstraint("const2", new String[]{"field2"});
        BusinessObjectAssert.assertThat(bo).canBeMarshalled();
    }

    @Test
    void could_have_optional_queries() {
        BusinessObject bo = BusinessObjectBuilder.aBO("aBo").withField(FieldBuilder.aBooleanField("field")).build();
        bo.addQuery("query", "select something from something", "returnType");
        BusinessObjectAssert.assertThat(bo).canBeMarshalled();
    }

    @Test
    void should_addQuery() {
        BusinessObject businessObject = new BusinessObject();
        Query query = businessObject.addQuery("userByName", "SELECT u FROM User u WHERE u.name='romain'", List.class.getName());
        Assertions.assertThat((List)businessObject.getQueries()).containsExactly((Object[])new Query[]{query});
    }

    @Test
    void isARelationField_should_be_false_with_an_emtpy_object() {
        BusinessObject bo = new BusinessObject();
        Assertions.assertThat((boolean)bo.isARelationField("any")).isFalse();
    }

    @Test
    void isARelationField_should_be_false_with_an_object_without_relation_field_but_with_the_right_name() {
        BusinessObject bo = new BusinessObject();
        bo.addField(FieldBuilder.aBooleanField("bool"));
        Assertions.assertThat((boolean)bo.isARelationField("bool")).isFalse();
    }

    @Test
    void isARelationField_should_be_false_with_an_object_without_relation_field() {
        BusinessObject bo = new BusinessObject();
        bo.addField(FieldBuilder.aBooleanField("bool"));
        Assertions.assertThat((boolean)bo.isARelationField("any")).isFalse();
    }

    @Test
    void isARelationField_should_be_true_with_an_object_with_relation_field() {
        BusinessObject bo = new BusinessObject();
        RelationField aggregationMultiple = FieldBuilder.aRelationField().withName("address").aggregation().referencing(this.addressBO()).build();
        bo.addField((Field)aggregationMultiple);
        Assertions.assertThat((boolean)bo.isARelationField("address")).isTrue();
    }

    private BusinessObject addressBO() {
        return BusinessObjectBuilder.aBO("Address").withField(FieldBuilder.aStringField("street").build()).withField(FieldBuilder.aStringField("city").build()).build();
    }

    @Test
    void should_return_simple_name() {
        BusinessObject businessObject = new BusinessObject();
        businessObject.setQualifiedName("com.company.model.Employee");
        ((AbstractStringAssert)Assertions.assertThat((String)businessObject.getSimpleName()).as("should return simple name", new Object[0])).isEqualTo("Employee");
    }

    @Test
    void should_to_string_return_return_all_field() {
        BusinessObject businessObject = BusinessObjectBuilder.aBO("aBo").withField(FieldBuilder.aBooleanField("field1")).withField(FieldBuilder.aBooleanField("field2")).build();
        UniqueConstraint uniqueConstraint = new UniqueConstraint();
        uniqueConstraint.setName("const");
        uniqueConstraint.setDescription("desc");
        uniqueConstraint.setFieldNames(List.of("field1"));
        businessObject.addUniqueConstraint(uniqueConstraint);
        businessObject.setDescription("description");
        businessObject.addQuery("queryName", "select * from Employee", String.class.getName());
        businessObject.setQualifiedName("com.company.model.Employee");
        ((AbstractStringAssert)Assertions.assertThat((String)businessObject.toString()).as("should return simple name", new Object[0])).contains(new CharSequence[]{"field1", "field2", "queryName"});
    }

    @Test
    void getField_should_return_field_matching_the_given_name() {
        BusinessObject businessObject = BusinessObjectBuilder.aBO("aBo").withField(FieldBuilder.aBooleanField("field1")).withField(FieldBuilder.aBooleanField("field2")).withField(FieldBuilder.aBooleanField("field3")).build();
        businessObject.setQualifiedName("com.company.model.Employee");
        Field field = businessObject.getField("field2");
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("field2");
    }

    @Test
    void getField_should_return_null_when_no_field_exists_for_the_given_name() {
        BusinessObject businessObject = BusinessObjectBuilder.aBO("aBo").withField(FieldBuilder.aBooleanField("field1")).build();
        businessObject.setQualifiedName("com.company.model.Employee");
        Field field = businessObject.getField("thisFieldDoesNotExist");
        Assertions.assertThat((Object)field).isNull();
    }
}

