/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.model.assertion;

import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.bonitasoft.engine.bdm.builder.BusinessObjectModelBuilder;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.bdm.model.assertion.Marshaller;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.RelationField;
import org.xml.sax.SAXException;

public class BusinessObjectAssert
extends AbstractAssert<BusinessObjectAssert, BusinessObject> {
    protected BusinessObjectAssert(BusinessObject actual) {
        super((Object)actual, BusinessObjectAssert.class);
    }

    public static BusinessObjectAssert assertThat(BusinessObject actual) {
        return new BusinessObjectAssert(actual);
    }

    public BusinessObjectAssert canBeMarshalled() {
        try {
            BusinessObjectModel bom = this.marshallUnmarshall((BusinessObject)this.actual);
            Assertions.assertThat((Object)((BusinessObject)bom.getBusinessObjects().get(0))).isNotNull();
            this.isEqualTo(bom.getBusinessObjects().get(0));
        }
        catch (Exception e) {
            this.failWithMessage("Expected <%s> to be marshallizable : <%s>", new Object[]{this.actual, e.getCause()});
        }
        return this;
    }

    public BusinessObjectAssert cannotBeMarshalled() {
        try {
            this.marshallUnmarshall((BusinessObject)this.actual);
            this.failWithMessage("Expected <%s> not to be marshallizable", new Object[]{this.actual});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    private BusinessObjectModel marshallUnmarshall(BusinessObject bo) throws JAXBException, IOException, SAXException {
        BusinessObjectModelBuilder bom = BusinessObjectModelBuilder.aBOM().withBO(bo);
        this.addReferencedBoToBom(bo, bom);
        return Marshaller.marshallUnmarshall(bom.build());
    }

    private void addReferencedBoToBom(BusinessObject bo, BusinessObjectModelBuilder bom) {
        for (Field field : bo.getFields()) {
            if (!(field instanceof RelationField) || bo.equals((Object)((RelationField)field).getReference())) continue;
            bom.withBO(((RelationField)field).getReference());
        }
    }
}

