/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.model.assertion;

import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.bonitasoft.engine.bdm.builder.BusinessObjectBuilder;
import org.bonitasoft.engine.bdm.builder.BusinessObjectModelBuilder;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.bdm.model.assertion.Marshaller;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.RelationField;
import org.xml.sax.SAXException;

public class FieldAssert
extends AbstractAssert<FieldAssert, Field> {
    protected FieldAssert(Field actual) {
        super((Object)actual, FieldAssert.class);
    }

    public static FieldAssert assertThat(Field actual) {
        return new FieldAssert(actual);
    }

    public FieldAssert canBeMarshalled() {
        try {
            BusinessObjectModel bom = this.marshallUnmarshall((Field)this.actual);
            Assertions.assertThat((Object)((BusinessObject)bom.getBusinessObjects().get(0))).isNotNull();
            Assertions.assertThat((Object)((Field)((BusinessObject)bom.getBusinessObjects().get(0)).getFields().get(0))).isNotNull();
            this.isEqualTo(((BusinessObject)bom.getBusinessObjects().get(0)).getFields().get(0));
        }
        catch (Exception e) {
            this.failWithMessage("Expected <%s> to be marshallizable but wasn't : <%s>", new Object[]{this.actual, e.getCause()});
        }
        return this;
    }

    public FieldAssert cannotBeMarshalled() {
        try {
            this.marshallUnmarshall((Field)this.actual);
            this.failWithMessage("Expected <%s> not to be marshallizable", new Object[]{this.actual});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    private BusinessObjectModel marshallUnmarshall(Field field) throws JAXBException, IOException, SAXException {
        BusinessObjectModelBuilder bom = BusinessObjectModelBuilder.aBOM().withBO(BusinessObjectBuilder.aBO("someUglyNameMightNotAppear").withField(field).build());
        this.addReferencedBoToBom(field, bom);
        return Marshaller.marshallUnmarshall(bom.build());
    }

    private void addReferencedBoToBom(Field field, BusinessObjectModelBuilder bom) {
        if (field instanceof RelationField) {
            RelationField f = (RelationField)field;
            bom.withBO(f.getReference());
        }
    }
}

