/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.model.assertion;

import java.util.Objects;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.QueryParameter;

public class QueryAssert
extends AbstractAssert<QueryAssert, Query> {
    public QueryAssert(Query actual) {
        super((Object)actual, QueryAssert.class);
    }

    public static QueryAssert assertThat(Query actual) {
        return new QueryAssert(actual);
    }

    public QueryAssert hasContent(String content) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected content of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualContent = ((Query)this.actual).getContent();
        if (!Objects.deepEquals(actualContent, content)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, content, actualContent});
        }
        return this;
    }

    public QueryAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((Query)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }

    public QueryAssert hasQueryParameters(QueryParameter ... queryParameters) {
        this.isNotNull();
        if (queryParameters == null) {
            throw new AssertionError((Object)"Expecting queryParameters parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Query)this.actual).getQueryParameters(), (Object[])queryParameters);
        return this;
    }

    public QueryAssert hasNoQueryParameters() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have queryParameters but had :\n  <%s>";
        if (((Query)this.actual).getQueryParameters().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Query)this.actual).getQueryParameters()});
        }
        return this;
    }

    public QueryAssert hasReturnType(String returnType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected returnType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualReturnType = ((Query)this.actual).getReturnType();
        if (!Objects.deepEquals(actualReturnType, returnType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, returnType, actualReturnType});
        }
        return this;
    }
}

