/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.model.field;

import org.assertj.core.api.Assertions;
import org.bonitasoft.engine.bdm.builder.BusinessObjectBuilder;
import org.bonitasoft.engine.bdm.builder.FieldBuilder;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.assertion.FieldAssert;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.RelationField;
import org.junit.jupiter.api.Test;

class RelationFieldTest {
    private final BusinessObject aBo = BusinessObjectBuilder.aBO("boName").withField(FieldBuilder.aBooleanField("aField")).build();

    RelationFieldTest() {
    }

    @Test
    void should_not_be_marshallizable_without_reference() {
        RelationField field = new RelationField();
        field.setName("aName");
        field.setType(RelationField.Type.AGGREGATION);
        FieldAssert.assertThat((Field)field).cannotBeMarshalled();
    }

    @Test
    void should_not_be_marshallizable_without_name() {
        RelationField field = new RelationField();
        field.setType(RelationField.Type.AGGREGATION);
        field.setReference(this.aBo);
        FieldAssert.assertThat((Field)field).cannotBeMarshalled();
    }

    @Test
    void should_not_be_marshallizable_without_type() {
        RelationField field = new RelationField();
        field.setReference(this.aBo);
        field.setName("aName");
        FieldAssert.assertThat((Field)field).cannotBeMarshalled();
    }

    @Test
    void should_be_marshallizable_with_only_name_type_and_reference() {
        RelationField field = new RelationField();
        field.setName("aName");
        field.setType(RelationField.Type.AGGREGATION);
        field.setReference(this.aBo);
        FieldAssert.assertThat((Field)field).canBeMarshalled();
    }

    @Test
    void should_not_be_marshallizable_whitout_fetchType() {
        RelationField field = new RelationField();
        field.setName("aName");
        field.setType(RelationField.Type.AGGREGATION);
        field.setReference(this.aBo);
        field.setFetchType(null);
        FieldAssert.assertThat((Field)field).cannotBeMarshalled();
    }

    @Test
    void should_have_a_default_fetchType_to_eager() {
        RelationField field = new RelationField();
        Assertions.assertThat((Comparable)field.getFetchType()).isEqualTo((Object)RelationField.FetchType.EAGER);
    }

    @Test
    void can_be_lazy() {
        RelationField field = new RelationField();
        field.setFetchType(RelationField.FetchType.LAZY);
        Assertions.assertThat((Comparable)field.getFetchType()).isEqualTo((Object)RelationField.FetchType.LAZY);
    }
}

