/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.model.field;

import org.bonitasoft.engine.bdm.model.assertion.FieldAssert;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.FieldType;
import org.bonitasoft.engine.bdm.model.field.SimpleField;
import org.junit.jupiter.api.Test;

class SimpleFieldTest {
    SimpleFieldTest() {
    }

    @Test
    void should_not_be_marshallizable_without_name() {
        SimpleField field = new SimpleField();
        field.setType(FieldType.BOOLEAN);
        FieldAssert.assertThat((Field)field).cannotBeMarshalled();
    }

    @Test
    void should_not_be_marshallizable_without_type() {
        SimpleField field = new SimpleField();
        field.setName("aName");
        FieldAssert.assertThat((Field)field).cannotBeMarshalled();
    }

    @Test
    void should_be_marshallizable_with_name_and_type() {
        SimpleField field = new SimpleField();
        field.setName("aName");
        field.setType(FieldType.BOOLEAN);
        FieldAssert.assertThat((Field)field).canBeMarshalled();
    }

    @Test
    void should_have_other_optionnal_attributes() {
        SimpleField field = new SimpleField();
        field.setName("aName");
        field.setType(FieldType.BOOLEAN);
        field.setCollection(Boolean.valueOf(true));
        field.setLength(Integer.valueOf(123));
        field.setNullable(Boolean.valueOf(true));
        FieldAssert.assertThat((Field)field).canBeMarshalled();
    }
}

