/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.bonitasoft.engine.bdm.validator.SQLNameValidator;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SQLNameValidatorTest {
    private SQLNameValidator sqlNameValidator;

    SQLNameValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        this.sqlNameValidator = new SQLNameValidator();
    }

    @Test
    void shouldIsValid_ReturnsTrue() {
        Assertions.assertThat((boolean)this.sqlNameValidator.isValid("EMPLOYEE")).isTrue();
        Assertions.assertThat((boolean)this.sqlNameValidator.isValid("employee")).isTrue();
        Assertions.assertThat((boolean)this.sqlNameValidator.isValid("employee_#")).isTrue();
        Assertions.assertThat((boolean)this.sqlNameValidator.isValid("name")).isTrue();
    }

    @Test
    void shouldSQLKeyword_contains_links_word() {
        Assertions.assertThat((Collection)SQLNameValidator.sqlKeywords).contains((Object[])new String[]{"LINKS"});
    }

    @Test
    void shouldIsValid_ReturnsFalse() {
        Assertions.assertThat((boolean)this.sqlNameValidator.isValid("E MPLOYEE")).isFalse();
        Assertions.assertThat((boolean)this.sqlNameValidator.isValid("@employee")).isFalse();
        Assertions.assertThat((boolean)this.sqlNameValidator.isValid("5employee")).isFalse();
        Assertions.assertThat((boolean)this.sqlNameValidator.isValid("\u00e9mployee")).isFalse();
        Assertions.assertThat((boolean)this.sqlNameValidator.isValid("employee.name")).isFalse();
        Assertions.assertThat((boolean)this.sqlNameValidator.isValid("order")).isFalse();
        Assertions.assertThat((boolean)this.sqlNameValidator.isValid("SCOPE")).isFalse();
    }

    @Test
    void shouldIsValid_ReturnsFalse_if_too_long() {
        this.sqlNameValidator = new SQLNameValidator(30);
        Assertions.assertThat((boolean)this.sqlNameValidator.isValid("IMTOOLONGANDVALIDATIONSHOULDFAILED")).isFalse();
        Assertions.assertThat((boolean)this.sqlNameValidator.isValid("IMNOTTOOLONG")).isTrue();
    }
}

