/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.glassfish.hk2.osgiresourcelocator.ResourceFinder;
import org.xml.sax.SAXException;

public class BusinessObjectModelConverter {
    private static final String BOM_XSD = "/bom.xsd";
    private static final String BOM_XML = "bom.xml";
    private static final String BDM_NAMESPACE = "http://documentation.bonitasoft.com/bdm-xml-schema/1.0";
    private final URL xsdUrl = Optional.ofNullable(ResourceFinder.findEntry((String)"/bom.xsd")).orElseGet(() -> BusinessObjectModelConverter.class.getResource(BOM_XSD));

    public byte[] zip(BusinessObjectModel bom) throws IOException, JAXBException, SAXException {
        return this.zipBom(this.marshall(bom));
    }

    public byte[] marshall(BusinessObjectModel bom) throws JAXBException, IOException, SAXException {
        String modelVersion = bom.getModelVersion();
        if (modelVersion == null || modelVersion.isEmpty()) {
            bom.setModelVersion("1.0");
        }
        return this.marshallObjectToXML(bom);
    }

    public BusinessObjectModel unzip(byte[] zippedBOM) throws IOException, JAXBException, SAXException {
        Map<String, byte[]> files = this.unzipBom(zippedBOM);
        byte[] bomXML = files.get(BOM_XML);
        if (bomXML == null) {
            throw new IOException("the file bom.xml is missing in the zip");
        }
        return this.unmarshall(bomXML);
    }

    public BusinessObjectModel unmarshall(byte[] bomXML) throws JAXBException, IOException, SAXException {
        return this.unmarshallXMLtoObject(this.addNamespace(bomXML));
    }

    private byte[] addNamespace(byte[] content) {
        String contentStr = new String(content);
        if (!contentStr.contains(BDM_NAMESPACE)) {
            String tagToFind = "<businessObjectModel";
            contentStr = contentStr.replace(tagToFind, String.format("%s xmlns=\"%s\"", tagToFind, BDM_NAMESPACE));
        }
        return contentStr.getBytes();
    }

    byte[] marshallObjectToXML(BusinessObjectModel jaxbModel) throws JAXBException, IOException, SAXException {
        if (jaxbModel == null) {
            return new byte[0];
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(this.xsdUrl);
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{jaxbModel.getClass()});
            Marshaller m = contextObj.createMarshaller();
            m.setSchema(schema);
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            m.marshal((Object)jaxbModel, (OutputStream)stream);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    BusinessObjectModel unmarshallXMLtoObject(byte[] xmlObject) throws JAXBException, IOException, SAXException {
        if (xmlObject == null) {
            return null;
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(this.xsdUrl);
        JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{BusinessObjectModel.class});
        Unmarshaller um = contextObj.createUnmarshaller();
        um.setSchema(schema);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(xmlObject);){
            JAXBElement jaxbElement = um.unmarshal((Source)new StreamSource(stream), BusinessObjectModel.class);
            BusinessObjectModel businessObjectModel = (BusinessObjectModel)jaxbElement.getValue();
            return businessObjectModel;
        }
    }

    private byte[] zipBom(byte[] fileContent) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(stream);){
            zos.putNextEntry(new ZipEntry(BOM_XML));
            zos.write(fileContent);
        }
        return stream.toByteArray();
    }

    private Map<String, byte[]> unzipBom(byte[] zippedContent) throws IOException {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zippedContent));){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = zis.read(buffer)) > 0) {
                        stream.write(buffer, 0, len);
                    }
                    resources.put(entry.getName(), stream.toByteArray());
                }
                entry = zis.getNextEntry();
            }
        }
        return resources;
    }
}

